/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ProgressIndicator
extends JPanel {
    ProgressMonitor m;
    private BoundedRangeModel progressModel;
    private JLabel messageLabel;
    private JLabel noteLabel;
    private JProgressBar progressBar;

    public ProgressIndicator() {
        this(null, null);
    }

    public ProgressIndicator(String string, String string2) {
        this(string, string2, 0, 100, true);
    }

    public ProgressIndicator(String string, String string2, int n, int n2, boolean bl) {
        this.initComponents();
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.progressModel = new DefaultBoundedRangeModel(0, 0, n, n2);
        this.progressBar.setModel(this.progressModel);
        this.setMessage(string);
        this.setNote(string2);
        this.setIndeterminate(bl);
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setNote(final String string) {
        String string2 = this.noteLabel.getText();
        this.noteLabel.setText(string);
        if (string2 == null || string == null && string2 != string) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator.this.noteLabel.setVisible(string != null);
                    ProgressIndicator.this.validate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public String getNote() {
        return this.noteLabel.getText();
    }

    public void setProgressModel(BoundedRangeModel boundedRangeModel) {
        this.progressModel = boundedRangeModel;
        this.progressBar.setModel(boundedRangeModel);
    }

    public int getMinimum() {
        return this.progressModel.getMinimum();
    }

    public void setMinimum(int n) {
        this.progressModel.setMinimum(n);
    }

    public void setProgress(int n) {
        this.progressModel.setValue(n);
    }

    public int getMaximum() {
        return this.progressModel.getMaximum();
    }

    public void setMaximum(int n) {
        this.progressModel.setMaximum(n);
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.messageLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.noteLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.noteLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.progressBar, gridBagConstraints);
    }
}

