/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class UndoableHandle
implements Handle {
    private Handle myWrappedHandle;
    private DrawingView myDrawingView;

    public UndoableHandle(Handle handle) {
        this.setWrappedHandle(handle);
    }

    public UndoableHandle(Handle handle, DrawingView drawingView) {
        this.setWrappedHandle(handle);
        this.setDrawingView(drawingView);
    }

    public Point locate() {
        return this.getWrappedHandle().locate();
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.getWrappedHandle().invokeStart(n, n2, drawingView);
    }

    public void invokeStart(int n, int n2, Drawing drawing) {
        this.getWrappedHandle().invokeStart(n, n2, drawing);
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.getWrappedHandle().invokeStep(n, n2, n3, n4, drawingView);
    }

    public void invokeStep(int n, int n2, Drawing drawing) {
        this.getWrappedHandle().invokeStep(n, n2, drawing);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.getWrappedHandle().invokeEnd(n, n2, n3, n4, drawingView);
        Undoable undoable = this.getWrappedHandle().getUndoActivity();
        if (undoable != null && undoable.isUndoable()) {
            drawingView.editor().getUndoManager().pushUndo(undoable);
            drawingView.editor().getUndoManager().clearRedos();
        }
    }

    public void invokeEnd(int n, int n2, Drawing drawing) {
        this.getWrappedHandle().invokeEnd(n, n2, drawing);
    }

    public Figure owner() {
        return this.getWrappedHandle().owner();
    }

    public Rectangle displayBox() {
        return this.getWrappedHandle().displayBox();
    }

    public boolean containsPoint(int n, int n2) {
        return this.getWrappedHandle().containsPoint(n, n2);
    }

    public void draw(Graphics graphics) {
        this.getWrappedHandle().draw(graphics);
    }

    protected void setWrappedHandle(Handle handle) {
        this.myWrappedHandle = handle;
    }

    protected Handle getWrappedHandle() {
        return this.myWrappedHandle;
    }

    public DrawingView getDrawingView() {
        return this.myDrawingView;
    }

    protected void setDrawingView(DrawingView drawingView) {
        this.myDrawingView = drawingView;
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.getDrawingView());
    }

    public void setUndoActivity(Undoable undoable) {
    }

    public Cursor getCursor() {
        return this.getWrappedHandle().getCursor();
    }
}

