#include "dispatchmode"
#include "config/config"

string Dispatchmode::modestr() const {
    ostringstream o;
    
    switch (mode()) {
    case m_leastconn:
	return ("least-connections");
    case m_roundrobin:
	return ("round-robin");
    case m_firstactive:
	return ("first-available");
    case m_external:
	return (static_cast<string>("external:") + config.externalalgorithm());
    case m_strict_hashed_ip:
	return ("strict-hashed-ip");
    case m_lax_hashed_ip:
	return ("lax-hashed-ip");
    case m_strict_stored_ip:
	o << "strict-stored-ip:" << config.ipstoretimeout();
	return (o.str());
    case m_lax_stored_ip:
	o << "lax-stored-ip:" << config.ipstoretimeout();
	return (o.str());
    default:
	return ("unknown");
    }
}
