/* eurephia_getsym.c  --  Retrieves symbols from dlopened libraries
 *
 *  GPLv2 only - Copyright (C) 2008 - 2012
 *               David Sommerseth <dazo@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; version 2
 *  of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

/**
 * @file   eurephia_getsym.c
 * @author David Sommerseth <dazo@users.sourceforge.net>
 * @date   2008-08-10
 *
 * @brief  Helper functions for handling dynamic loaded objects (.so files)
 *
 */

#include <stdio.h>
#include <dlfcn.h>

#include <eurephia_context.h>
#include "eurephia_log.h"

/**
 * Retrieves a function pointer to a given function name
 *
 * @param ctx    eurephiaCTX
 * @param dlh    Handler which dlopen() returned
 * @param symnam Name of the function to find
 *
 * @return Returns a pointer to the function if it was found, otherwise NULL is returned.
 */
void *eGetSym(eurephiaCTX *ctx, void *dlh, const char *symnam)
{
        void *func = NULL;

        if( ctx->fatal_error > 0 ) {
                return NULL;
        }

        DEBUG(ctx, 30, "Locating driver function '%s'", symnam);
        func = dlsym(dlh, symnam);
        if( func == NULL ) {
                eurephia_log(ctx, LOG_PANIC, 0, "Could not find needed '%s' function in driver", symnam);
                ctx->fatal_error = 1;
        }
        return func;
}

