import unittest
import warnings

from iotas.uri_to_note_creator import UriToNoteCreator, UriParseResult
from iotas.note import Note

warnings.filterwarnings("ignore", "version")


class Test(unittest.TestCase):

    def test_parse(self) -> None:
        creator = UriToNoteCreator()

        self.assertFalse(creator.parse("plain").success)
        self.assertFalse(creator.parse("uri://text").success)
        self.assertFalse(creator.parse("iotas-notes://text").success)
        self.assertFalse(creator.parse("iotas-notes://?content=text").success)
        self.assertFalse(creator.parse("iotas-notes://create-note?content=text").success)
        self.assertFalse(creator.parse("iotas-notes://create-note?title=text").success)

        result = creator.parse("iotas-notes://create-note?content=text&title=title")
        self.assertIsInstance(result, UriParseResult)
        self.assertTrue(result.success)
        self.assertIsNotNone(result.note)
        assert result.note is not None  # mypy
        self.assertIsInstance(result.note, Note)
        self.assertEqual(result.note.content, "text")
        self.assertEqual(result.note.title, "title")
        self.assertFalse(result.open)

        result = creator.parse("iotas-notes://create-note?content=text&title=title&open=1")
        self.assertTrue(result.success)
        self.assertIsNotNone(result.note)
        assert result.note is not None  # mypy
        self.assertEqual(result.note.content, "text")
        self.assertEqual(result.note.title, "title")
        self.assertTrue(result.open)
