/*=============================================================================
**  Lynkeos
**  $Id: processing_core.h,v 1.9 2005/01/27 23:15:44 j-etienne Exp $
**-----------------------------------------------------------------------------
**
**  Created by Jean-Etienne LAMIAUD on Fri Dec 05 2003.
**  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
**-----------------------------------------------------------------------------
*/

#ifndef __PROCESSING_CORE_H
#define __PROCESSING_CORE_H

#include <math.h>
#include <complex.h>
#include <fftw3.h>

/* Key common to model/controller and processing */
#define K_REFERENCE_ITEM_KEY @"reference"



#ifdef GNUSTEP
typedef unsigned char u_char;
typedef unsigned short u_short;
#endif


/* Types used in all processing routines */
#ifdef FLOAT_PIXELS
typedef float REAL;
#else
typedef double REAL;
#endif

typedef struct
{
    REAL red;
    REAL green;
    REAL blue;
} RGB;

#ifdef FLOAT_PIXELS
typedef fftwf_complex COMPLEX, *SPECTRUM;
typedef fftwf_plan FFT_PLAN;
#else
typedef fftw_complex COMPLEX, *SPECTRUM;
typedef fftw_plan FFT_PLAN;
#endif

typedef struct
{
   u_char nplanes;
   u_short w, h, pw;
   SPECTRUM spectrum;
   u_char goal;
   FFT_PLAN direct, inverse;
} FFT_DATA;

/* Functions */
extern void initializeProcessing();

extern u_short numberOfCpus;

#endif
