# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** hub, perform selected actions

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/hub_actions.rb;hb=HEAD>

=end
module SiSU_Hub_Actions
  class HubActions
    require_relative 'utils_composite'                    # utils_composite.rb
    include SiSU_Composite_Doc_Utils                      # composite doc, .ssm, extract all related insert files, array of filenames test
    def initialize(opt)
      @opt=opt
    end
    def report
      def version_info?
        if @opt.act[:version_info][:set]==:on
          SiSU_Env::InfoAbout.new(@opt).sisu_version
        end
      end
      def version_number_git?
        if @opt.act[:version_info][:set]==:on \
        || @opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            ' ' + SiSU_is.git_version_info?
          ).grey
        end
      end
      def version_dir?
        if @opt.act[:version_info][:set]==:on \
        || @opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            ' ' + File.dirname(__FILE__)
          ).grey
        end
      end
      def version_info_extra?
        if @opt.act[:version_info][:set]==:on \
        || @opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on
          if SiSU_is.git_version_info?
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              ' ' + File.dirname(__FILE__) + \
              '  vcr: ' + SiSU_is.git_version_info?
            ).grey
          else
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              ' ' + File.dirname(__FILE__)
            ).grey
          end
        end
      end
      self
    end
    def prepare
      def site?
        if @opt.act[:site_init][:set]==:on               #% --init-site, -C initialize/configure
          require_relative 'conf'                        #% --init-site, -C initialize/configure
          SiSU_Initialize::Source.new(@opt).read
          if @opt.act[:rsync][:set]==:on
            if @opt.selections.str =~/--init(?:ialize)?=site/ \
            and @opt.selections.str =~/RZ/
              SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site_rsync_match
            else SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site_rsync
            end
          elsif @opt.act[:scp][:set]==:on
            if @opt.selections.str =~/--init(?:ialize)?=site/ \
            and @opt.selections.str =~/CCr/
              SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site_all
            else SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site
            end
          end
        end
      end
      def remote_site?
        if @opt.act[:site_init][:set]==:on
          if @opt.act[:site_init][:set]==:on               #% --init-site, -C initialize/configure
            #require_relative 'conf'                        #% --init-site, -C initialize/configure
            #SiSU_Initialize::Source.new(@opt).read
            #if @opt.act[:rsync][:set]==:on
            #  if @opt.selections.str =~/--init(?:ialize)?=site/ \
            #  and @opt.selection =~/RZ/
            #    SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site_rsync_match
            #  else SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site_rsync
            #  end
            #elsif @opt.act[:scp][:set]==:on
            #  if @opt.selections.str =~/--init(?:ialize)?=site/ \
            #  and @opt.selection =~/CCr/
            #    SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site_all
            #  else SiSU_Hub_Actions::Operations.new(@opt).remote_put_base_site
            #  end
            #end
          end
        end
      end
      def sql?
        if @opt.act[:psql_createdb][:set]==:on \
        or @opt.act[:psql_create][:set]==:on \
        or @opt.act[:psql_drop][:set]==:on
          done=:ok
          if @opt.act[:psql][:set]==:on
            require_relative 'dbi'
            SiSU_DBI::SQL.new(@opt).connect
          end
        end
        if @opt.act[:sqlite_createdb][:set]==:on \
        or @opt.act[:sqlite_create][:set]==:on \
        or @opt.act[:sqlite_drop][:set]==:on
          done=:ok
          if @opt.act[:sqlite][:set]==:on
            require_relative 'dbi'
            SiSU_DBI::SQL.new(@opt).connect
          end
        end
      end
      def search_form?
        if @opt.act[:sample_search_form][:set]==:on      #% --sample-search-form, -F cgi sample search form
          SiSU_Hub_Actions::Operations.new(@opt).cgi
        end
      end
      def webrick?
        if @opt.act[:webrick][:set]==:on                 #% --webrick, -W webrick
          SiSU_Hub_Actions::Operations.new(@opt).webrick
        end
      end
      self
    end
    def outputs
      def each_file
        def abstract_objects?
          if @opt.act[:ao][:set]==:on                    #% --ao --dal, -m
            if @opt.f_pths.length > 0
              unless @opt.act[:po4a_shelf][:set]==:on    # --po4a-shelf
                if @opt.fno =~ /\.ssm$/
                  require_relative 'ao_composite'        # ao_composite.rb #pre-processing
                  SiSU_Assemble::Composite.new(@opt).read
                end
                require_relative 'ao'                    # ao.rb
                SiSU_AO::Source.new(@opt).read
              end
            else
              msg='document abstraction request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def qrcode?
          if @opt.act[:qrcode][:set]==:on                #% --qrcode, -Q
            if @opt.f_pths.length > 0
              require_relative 'qrcode'                  # qrcode.rb
              SiSU_QRcode::Source.new(@opt).read
            else
              msg='qrcode request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def hash_digests?
          if @opt.act[:hash_digests][:set]==:on          #% --hash-digests, -N digest tree
            if @opt.f_pths.length > 0
              require_relative 'digests'                 # digests.rb
              SiSU_DigestView::Source.new(@opt).read
            else
              msg='hash digest request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def text?
          if @opt.act[:txt][:set]==:on                   #% --txt, -t -a
            if @opt.f_pths.length > 0
              require_relative 'txt_plain'               #  txt_plain.rb
              SiSU_Txt_Plain::Source.new(@opt).read
            else
              msg='text request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:txt_textile][:set]==:on           #% --textile
            if @opt.f_pths.length > 0
              require_relative 'txt_textile'             #txt_textile.rb
              SiSU_Txt_Textile::Source.new(@opt).read
            else
              msg='textile request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:txt_asciidoc][:set]==:on          #% --asciidoc
            if @opt.f_pths.length > 0
              require_relative 'txt_asciidoc'            # txt_asciidoc.rb
              SiSU_Txt_AsciiDoc::Source.new(@opt).read
            else
              msg='asciidoc request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:txt_markdown][:set]==:on          #% --markdown
            if @opt.f_pths.length > 0
              require_relative 'txt_markdown'            # txt_markdown.rb
              SiSU_Txt_Markdown::Source.new(@opt).read
            else
              msg='markdown request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:txt_rst][:set]==:on               #% --rst, --rest
            if @opt.f_pths.length > 0
              require_relative 'txt_rst'                 # txt_rst.rb
              SiSU_Txt_rST::Source.new(@opt).read
            else
              msg='rst request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:txt_orgmode][:set]==:on          #% --orgmode
            if @opt.f_pths.length > 0
              require_relative 'txt_orgmode'            # txt_orgmode.rb
              SiSU_Txt_OrgMode::Source.new(@opt).read
            else
              msg='orgmode request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def html?
          if @opt.act[:html][:set]==:on                  #% --html, -h
            if @opt.f_pths.length > 0
              require_relative 'html'                    # html.rb
              SiSU_HTML::Source.new(@opt).read
            else
              msg='html request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          else
            if @opt.act[:html_seg][:set]==:on            #% --html-seg
              if @opt.f_pths.length > 0
                require_relative 'html'                  # html.rb
                SiSU_HTML::Source.new(@opt).read
              else
                msg='html seg request requires sisu markup files'
                if (@opt.act[:verbose_plus][:set]==:on \
                || @opt.act[:maintenance][:set]==:on)
                  SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                    mark(msg)
                else puts msg
                end
              end
            end
            if @opt.act[:html_scroll][:set]==:on         #% --html-scroll
              if @opt.f_pths.length > 0
                require_relative 'html'                  # html.rb
                SiSU_HTML::Source.new(@opt).read
              else
                msg='html scroll request requires sisu markup files'
                if (@opt.act[:verbose_plus][:set]==:on \
                || @opt.act[:maintenance][:set]==:on)
                  SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                    mark(msg)
                else puts msg
                end
              end
            end
          end
          if @opt.act[:concordance][:set]==:on           #% --concordance, -w
            if @opt.f_pths.length > 0
              require_relative 'html_concordance'        # html_concordance.rb
              SiSU_Concordance::Source.new(@opt).read
            else
              msg='concordance request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def xhtml?
          if @opt.act[:xhtml][:set]==:on                 #% --xhtml, -b
            if @opt.f_pths.length > 0
              require_relative 'xhtml'                   # xhtml.rb
              SiSU_XHTML::Source.new(@opt).read
            else
              msg='xhtml request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:epub][:set]==:on                  #% --epub, -e
            if @opt.f_pths.length > 0
              require_relative 'xhtml_epub2'             # xhtml_epub2.rb
              SiSU_XHTML_EPUB2::Source.new(@opt).read
            else
              msg='epub request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def xml?
          if @opt.act[:odt][:set]==:on                   #% --odt, -o
            if @opt.f_pths.length > 0
              require_relative 'xml_odf_odt'             # xml_odf_odt.rb
              SiSU_XML_ODF_ODT::Source.new(@opt).read
            else
              msg='odt request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:xml_scaffold_structure_sisu][:set]==:on #% --xml-scaffold --xml-scaffold-sisu
            if @opt.f_pths.length > 0
              require_relative 'xml_scaffold_structure_sisu'   #  xml_scaffold_structure_sisu.rb
              SiSU_XML_Scaffold_Structure_Sisu::Source.new(@opt).read
            else
              msg='xml scaffold request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:xml_scaffold_structure_collapse][:set]==:on #% --xml-scaffold-collapse
            if @opt.f_pths.length > 0
              require_relative 'xml_scaffold_structure_collapsed'  # xml_scaffold_structure_collapsed.rb
              SiSU_XML_Scaffold_Structure_Collapse::Source.new(@opt).read
            else
              msg='xml scaffold request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:xml_docbook_book][:set]==:on      #% --xml-docbook
            if @opt.f_pths.length > 0
              require_relative 'xml_docbook5'            # xml_docbook5.rb
              SiSU_XML_Docbook_Book::Source.new(@opt).read
            else
              msg='docbook request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:xml_fictionbook][:set]==:on       #% --xml-fictionbook
            if @opt.f_pths.length > 0
              require_relative 'xml_fictionbook2'        # xml_fictionbook2.rb
              SiSU_XML_Fictionbook::Source.new(@opt).read
            else
              msg='fictionbook request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:xml_sax][:set]==:on               #% --xml-sax, -x
            if @opt.f_pths.length > 0
              require_relative 'xml_sax'                 # xml_sax.rb
              SiSU_XML_SAX::Source.new(@opt).read
            else
              msg='xml sax request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:xml_dom][:set]==:on               #% --xml-dom, -X
            if @opt.f_pths.length > 0
              require_relative 'xml_dom'                 # xml_dom.rb
              SiSU_XML_DOM::Source.new(@opt).read
            else
              msg='xml dom request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def pdf?
          if @opt.act[:pdf][:set]==:on \
          or @opt.act[:pdf_p][:set]==:on \
          or @opt.act[:pdf_l][:set]==:on                 #% --pdf-l --pdf, -p
            if @opt.f_pths.length > 0
              require_relative 'texpdf'                  # texpdf.rb
              SiSU_TeX::Source.new(@opt).read
            else
              msg='pdf request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def man_or_info?
          if @opt.act[:manpage][:set]==:on               #% --manpage, -i
            if @opt.f_pths.length > 0
              require_relative 'manpage'                 # manpage.rb
              SiSU_Manpage::Source.new(@opt).read
            else
              msg='manpage request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:texinfo][:set]==:on               #% --texinfo, -I
            if @opt.f_pths.length > 0
              require_relative 'texinfo'                 # texinfo.rb
              SiSU_TexInfo::Source.new(@opt).read
            else
              msg='texinfo request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def sqlite_discrete?
          if @opt.act[:sqlite_discrete][:set]==:on       #% --sqlite, -d
            if @opt.f_pths.length > 0
              require_relative 'dbi_discrete'            # dbi_discrete.rb
              SiSU_DBI_Discrete::SQL.new(@opt).build
            else
              msg='sqlite (discrete) request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def po4a_make?
          if @opt.act[:po4a_sst_ao_sst][:set]==:on               #% --po4a-ao
            if @opt.f_pths.length > 0
              require_relative 'src_po4a_sst_ao_sst'
              SiSU_SStm_AO_SStm::Source.new(@opt).read_process_src_files # src_po4a_sst_ao_sst.rb
            else
              msg='sst request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def elasticsearch?
          if @opt.act[:elasticsearch][:set]==:on         #% --elastic, -x
            if @opt.f_pths.length > 0
              require_relative 'json_elastic'            # json_elastic.rb
              SiSU_Elastic::Source.new(@opt).read
            else
              msg='easticsearch request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def manifest?
          if @opt.act[:manifest][:set]==:on              #% --manifest, -y
            if @opt.f_pths.length > 0
              begin
                require_relative 'html_manifest'           # html_manifest.rb
                ((@opt.act[:sisupod][:set]==:on \
                || @opt.act[:share_source][:set]==:on \
                || @opt.act[:po4a_sstm][:set]==:on) \
                && @opt.f_pths.length < 2 ) \
                ? nil
                : SiSU_Manifest::Source.new(@opt).read
              rescue
              end
            else
              msg='manifest request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def harvest?
          if @opt.act[:harvest][:set]==:on               #% --harvest
            if @opt.f_pths.length > 0
              require_relative 'html_harvest'            # html_harvest.rb
              SiSU_Harvest::Source.new(@opt).read
            else
              msg='harvest request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:yellow).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        self
      end
      def loop_files
        def share_source?
          if @opt.act[:sisupod][:set]==:on \
          or @opt.act[:share_source][:set]==:on \
          or @opt.act[:po4a_sstm][:set]==:on \
          or @opt.act[:git][:set]==:on
            begin
              if @opt.f_pths.length > 0
                require_relative 'src_shared'
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option do
                  SiSU_Source::SiSUpodSource.new(@opt).read
                end
              else
                msg='share markup source request requires sisu markup files'
                if (@opt.act[:verbose_plus][:set]==:on \
                || @opt.act[:maintenance][:set]==:on)
                  SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                    mark(msg)
                else puts msg
                end
              end
              if @opt.act[:sisupod][:set]==:on           #% --sisupod, -S
                if @opt.f_pths.length > 0
                  require_relative 'src_sisupod_make'    # src_sisupod_make.rb
                  begin
                    SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                    loop_files_on_given_option_bundle do
                      SiSU_Doc::Source.new(@opt).sisupod_tar_xz
                    end
                  ensure
                  end
                else
                  msg='sisupod (share markup source) request requires sisu markup files'
                  if (@opt.act[:verbose_plus][:set]==:on \
                  || @opt.act[:maintenance][:set]==:on)
                    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                      mark(msg)
                  else puts msg
                  end
                end
              end
              if @opt.act[:git][:set]==:on               #% --git, -g
                if @opt.f_pths.length > 0
                  require_relative 'git'                 # git.rb
                  begin
                    SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                    loop_files_on_given_option do
                      SiSU_Git::Source.new(@opt).read
                    end
                  ensure
                    SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                    loop_files_on_given_option_bundle do
                      SiSU_Git::Source.new(@opt).git_commit
                    end
                  end
                else
                  msg='git request requires sisu markup files'
                  if (@opt.act[:verbose_plus][:set]==:on \
                  || @opt.act[:maintenance][:set]==:on)
                    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                      mark(msg)
                  else puts msg
                  end
                end
              end
              if (@opt.act[:sisupod][:set]==:on \
              || @opt.act[:share_source][:set]==:on \
              || @opt.act[:po4a_sstm][:set]==:on) \
              and @opt.act[:manifest][:set]==:on         #% --manifest, -y
                if @opt.f_pths.length > 0
                  require_relative 'html_manifest'            # html_manifest.rb
                  begin
                  ensure
                    SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                    loop_files_on_given_option_bundle do
                      SiSU_Manifest::Source.new(@opt).read
                    end
                  end
                else
                  msg='manifest request requires sisu markup files'
                  if (@opt.act[:verbose_plus][:set]==:on \
                  || @opt.act[:maintenance][:set]==:on)
                    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                      mark(msg)
                  else puts msg
                  end
                end
              end
            ensure
              if @opt.f_pths.length > 0
                env=SiSU_Env::InfoEnv.new(@opt.fns)
                path_pod=env.processing_path.processing_sisupod(@opt).paths
                unless @opt.act[:maintenance][:set]==:on
                  FileUtils::rm_rf("#{path_pod[:sisupod]}/*") \
                    if FileTest.directory?(path_pod[:sisupod])
                end
              else
                #SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                #  mark('*** request requires sisu markup files')
              end
            end
          end
          if @opt.act[:share_source][:set]==:on
            if @opt.f_pths.length > 0
              require_relative 'src_sisupod_sstm'           # src_sisupod_sstm.rb
              begin
              ensure
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option_bundle do
                  SiSU_Markup::Source_Sisupod.new(@opt).read
                end
              end
            else
              msg='share markup source request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:po4a_sstm][:set]==:on                    #% --po4a-sst
            if @opt.f_pths.length > 0
              require_relative 'src_po4a_sstm'
              begin
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option do
                  SiSU_Markup::Source_Po4a.new(@opt).read       # src_po4a_sstm.rb
                end
              ensure
              end
            else
              msg='sst request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:po4a_sst_ao_sst][:set]==:on               #% --po4a-ao
            if @opt.f_pths.length > 0
              require_relative 'src_po4a_sst_ao_sst'
              begin
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option do
                  SiSU_SStm_AO_SStm::Source.new(@opt).read_setup # src_po4a_sst_ao_sst.rb
                end
              ensure
              end
            else
              msg='sst request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:po4a_shelf][:set]==:on            #% --po4a-shelf
            if @opt.f_pths.length > 0
              require_relative 'src_po4a_shelf'
              begin
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option do
                  SiSU_Po4a::Source.new(@opt).read       # src_po4a_shelf.rb
                end
              ensure
              end
            else
              msg='src_po4a_shelf request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:images][:set]==:on                #% --images, -j
            if @opt.f_pths.length > 0
              require_relative 'shared_images'
              SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
              loop_files_on_given_option do
                SiSU_Images::Source.new(@opt).read       # shared_images.rb
              end
            else
              msg='place images request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def run_termsheet? #broken, revisit later
          if @opt.selections.str =~/--termsheet/         #% -T termsheet/standard form #fix later
            if @opt.f_pths.length > 0
              @opt.files.each do |fns|
                if FileTest.file?(fns)
                  @opt.fns=fns
                  case @opt.fns
                  when /\.(termsheet.rb)$/
                    SiSU_Hub_Actions::Operations.new(@opt).termsheet
                  else                                   #print "not processed --> ", fns, "\n"
                  end
                else SiSU_Hub_Actions::Operations.new(@opt).not_found
                end
              end
            else
              msg='process termsheet request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def sql?
          if @opt.act[:psql][:set]==:on                  #% --pg, -D
            if @opt.f_pths.length > 0
              require_relative 'dbi'
              SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
              loop_files_on_given_option do
                SiSU_DBI::SQL.new(@opt).connect          # dbi.rb
              end
            else
              msg='pgsql request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
          if @opt.act[:sqlite][:set]==:on                #% --sqlite, -d
            if @opt.f_pths.length > 0
              require_relative 'dbi'
              SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
              loop_files_on_given_option do
                SiSU_DBI::SQL.new(@opt).connect          # dbi.rb
              end
            else
              msg='sqlite request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        def manifest?
          if @opt.act[:manifest][:set]==:on              #% --manifest, -y
            if @opt.f_pths.length > 1
              require_relative 'html_manifest'
              SiSU_Hub_Loops::OptionLoopFiles.new(@opt).manifest_on_files_translated do
                SiSU_Manifest::Source.new(@opt).read     # html_manifest.rb
              end
            end
          end
        end
        def sitemaps?
          if @opt.act[:sitemap][:set]==:on               #% --sitemap, -Y
            if @opt.f_pths.length > 0
              require_relative 'sitemaps'
              SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
              loop_files_on_given_option do
                SiSU_Sitemaps::Source.new(@opt).read     # sitemaps.rb
              end
            end
          end
        end
        def remote_placement?
          if @opt.act[:harvest][:set] !=:on
            if @opt.act[:scp][:set]==:on                 #% -r copy to remote server
              if @opt.f_pths.length > 0
                require_relative 'remote'                # remote.rb
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option do
                  SiSU_Remote::Put.new(@opt).scp
                end
              end
            end
            if @opt.act[:rsync][:set]==:on               #% -R copy to remote server
              if @opt.f_pths.length > 0
                require_relative 'remote'                # remote.rb
                SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
                loop_files_on_given_option do
                  SiSU_Remote::Put.new(@opt).rsync
                end
              end
            end
          else
          end
        end
        def urls?
          if @opt.act[:urls_selected][:set]==:on         #% --urls
            if @opt.f_pths.length > 0
              require_relative 'urls'
              SiSU_Hub_Loops::OptionLoopFiles.new(@opt).
              loop_files_on_given_option do
                SiSU_Urls::Source.new(@opt).read         #% urls.rb
              end
            else
              msg='urls request requires sisu markup files'
              if (@opt.act[:verbose_plus][:set]==:on \
              || @opt.act[:maintenance][:set]==:on)
                SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:cyan).
                  mark(msg)
              else puts msg
              end
            end
          end
        end
        self
      end
      def init?
        SiSU_Env::InfoProcessingFlag.new
        if @opt.act[:ao][:set]==:on \
        or @opt.act[:maintenance][:set]==:on             #% --maintenance, -M
          env=SiSU_Env::InfoEnv.new(@opt.fns)
          path={}
          path[:css]=env.path.output + '/_sisu/css'
          path[:xml]=env.path.output + '/_sisu/xml'
          path[:xsd]=path[:xml] + '/xsd'
          path[:xsd]=path[:xml] + '/rnc'
          path[:xsd]=path[:xml] + '/rng'
          re_p3=/(sisupod(?:\.txz)?|\S+?\.ss[mt]\.txz|[^\/]+?\.ssp)$/
          unless @opt.files.join(',') =~ re_p3 #do not mix pods with source markup files in command line
            if @opt.act[:maintenance][:set] ==:on
              $VERBOSE=false                             #debug $VERBOSE=true
            end
          end
          re_p2=/(sisupod(?:\.zip)?|\S+?\.ss[mt]\.zip)$/
          unless @opt.files.join(',') =~ re_p2 #do not mix pods with source markup files in command line
            if @opt.act[:maintenance][:set] ==:on
              $VERBOSE=false                             #debug $VERBOSE=true
            end
          end
        end
        if @opt.act[:ao][:set]==:on
          @retry_count= -1
          begin
            @get_s,@get_p,@get_pl=[],[],[]
            re_s=/(\S+?\.-sst)$/
            re_p3=/((?:https?|file):\/\/\S+?(?:\/\S+?\.ss[mt]\.txz|sisupod(?:\.txz)?|\.ssp))/
            re_pl3=/^(\/\S+?\.ss[mt]\.txz)/
            @opt.files.each do |fns|
              if fns =~re_s
                @get_s << @opt.f_pths[0][:url]
              end
              if fns =~re_p3
                @get_p << re_p3.match(fns)[1] if re_p3
              end
              if fns =~re_pl3
                @get_pl << re_pl3.match(fns)[1] if re_p3
              end
            end
            if @get_s.length > 0                         #% remote markup file .sst
              require_relative 'remote'                  # remote.rb
              SiSU_Remote::Get.new(@opt,@get_s).fns
              SiSU_Hub_Actions::Operations.new.counter
            end
            if @get_p.length > 0                         #% remote sisupod
              require_relative 'remote'                  # remote.rb
              SiSU_Remote::Get.new(@opt,@get_p).sisupod
            end
          rescue
            SiSU_Errors::Rescued.new($!,$@,@opt,@fns).location do
              __LINE__.to_s + ':' + __FILE__
            end
            @retry_count +=1
            retry unless @retry_count > 1
          ensure
          end
        end
      end
      self
    end
  end
  class Operations
    @@n_do=0
    def initialize(opt='')
      @opt=opt
      @cX=SiSU_Screen::Ansi.new(@opt).cX
    end
    def counter
      @@n_do=0
    end
    def remote_put_base_site_rsync                       # -CR
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark(:cyan) \
        if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                          # remote.rb
      SiSU_Remote::Put.new(@opt).rsync_base
    end
    def remote_put_base_site_rsync_match                 # -CCRZ
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark(:cyan) \
        if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                          # remote.rb
      SiSU_Remote::Put.new(@opt).rsync_base_sync
    end
    def remote_put_base_site                             # -Cr
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark(:cyan) \
        if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                          # remote.rb
      SiSU_Remote::Put.new(@opt).scp_base
    end
    def remote_put_base_site_all                         # -CCr
      SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark(:cyan) \
        if @opt.act[:maintenance][:set] ==:on
      require_relative 'remote'                          # remote.rb
      SiSU_Remote::Put.new(@opt).scp_base_all
    end
    def cgi                                              # -F
      require_relative 'cgi'                             # cgi.rb
      SiSU_CGI::SearchSQL.new(@opt).read
    end
    def termsheet                                        # -t
      system("sisu_termsheet #{@opt.selections.str} #{@opt.fns}\n")
      @@n_do=@@n_do+1
      SiSU_Screen::Ansi.new(
        @opt.selections.str,@@n_do,
        'Termsheet(s) processed'
      ).term_sheet_title unless @opt.act[:quiet][:set] ==:on
    end
    def webrick                                          # -W
      prt=SiSU_Env::InfoEnv.new(@fns).port.webrick_port
      puts %{#{@cX.blue}<<#{@cX.off}#{@cX.green}Start Webrick web server on port: #{prt}#{@cX.off}#{@cX.blue}>> #{@cX.off*2} }
      require_relative 'webrick'
      SiSU_Webserv::WebrickStart.new
    end
    def not_found
      puts "\n#{@cX.fuchsia}FILE NOT FOUND:#{@cX.off} << #{@opt.fns} >> - requested #{@opt.selections.str} processing skipped\n"
    end
    def convert_name_message(fns,type,i,o,rune)
      %{\nIn filename: "#{@cX.fuchsia}#{fns}#{@cX.off}" << #{type} >> #{@cX.fuchsia}is apre 0.36 markup filename.#{@cX.off} #{@cX.brown}Please rename your file.#{@cX.off}\n\tAs of sisu-0.37, SiSU markup files with #{@cX.brown}the extensions #{i} should be re-named #{o}#{@cX.off}\n\tif you have the program called 'rename' installed, the following rune should do the trick:\n\t\t#{rune}\n\talternatively try:\n\t\tsisu --convert --36to37 #{fns}\n\trequested #{@opt.selections.str} processing skipped\n}
    end
    def not_recognised
      case @opt.fns
      when /(\.s[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.s[123]$/\.sst/' *.s{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.s1 .s2 and .s3','.sst',rune)
      when /(\.r[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,'\1')
        rune=%q{rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.r1 .r2 and .r3','.sst',rune)
        puts %{\n\tNote also that you will need to change the names of the files called/required\n\twithin the document text to build the composite document\n\t\t.s1 .s2 .s3 should be .sst \n\t\t.si should be .ssi\n\trequested #{@opt.selections.str} processing skipped\n}
      when /(\.ssi)$/
        puts "\n#{@cX.fuchsia}component filetype:#{@cX.off} << #{@opt.fns} >> - is not a processed filetype, (it may be used as a component of a .ssm markup file)\n\trequested #{@opt.selections.str} processing skipped\n"
      else
        puts "\n#{@cX.fuchsia}FILETYPE NOT RECOGNISED:#{@cX.off} << #{@opt.fns} >> - is not a recognized filetype,\n\trequested #{@opt.selections.str} processing skipped\n"
      end
    end
  end
end
__END__
