/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.AlignSimple;
import jebl.evolution.align.TracebackSimple;
import jebl.evolution.align.scores.Scores;
import jebl.util.ProgressListener;

public class SmithWaterman
extends AlignSimple {
    public SmithWaterman(Scores sub, float d) {
        super(sub, d);
    }

    public void doAlignment(String sq1, String sq2, ProgressListener progress) {
        super.prepareAlignment(sq1, sq2);
        char[] s1 = sq1.toCharArray();
        char[] s2 = sq2.toCharArray();
        int n = this.n;
        int m = this.m;
        float[][] score = this.sub.score;
        int maxi = n;
        int maxj = m;
        float maxval = Float.NEGATIVE_INFINITY;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                float val;
                float s = score[s1[i - 1]][s2[j - 1]];
                this.F[i][j] = val = SmithWaterman.max(0.0f, this.F[i - 1][j - 1] + s, this.F[i - 1][j] - this.d, this.F[i][j - 1] - this.d);
                if (val == 0.0f) {
                    this.B[i][j].setTraceback(-1, -1);
                } else if (val == this.F[i - 1][j - 1] + s) {
                    this.B[i][j].setTraceback(i - 1, j - 1);
                } else if (val == this.F[i - 1][j] - this.d) {
                    this.B[i][j].setTraceback(i - 1, j);
                } else if (val == this.F[i][j - 1] - this.d) {
                    this.B[i][j].setTraceback(i, j - 1);
                } else {
                    throw new Error("Error in SmithWaterman alignment.");
                }
                if (!(val > maxval)) continue;
                maxval = val;
                maxi = i;
                maxj = j;
            }
        }
        this.B0 = new TracebackSimple(maxi, maxj);
    }

    public void doAlignment(String sq1, String sq2) {
        this.doAlignment(sq1, sq2, null);
    }
}

