/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.propagation;

import choco.kernel.common.util.objects.BipartiteSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.propagation.event.PropagationEvent;
import choco.kernel.solver.propagation.queue.EventQueue;
import java.util.Iterator;

public class ConstraintEventQueue
implements EventQueue {
    private PropagationEngine engine;
    private BipartiteSet<PropagationEvent> partition;

    public ConstraintEventQueue(PropagationEngine engine) {
        this.engine = engine;
        this.partition = new BipartiteSet();
    }

    @Override
    public void clear() {
        this.partition.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.partition.getNbLeft() == 0;
    }

    @Override
    public PropagationEvent popEvent() {
        PropagationEvent event = this.partition.moveLastLeft();
        if (event == null) {
            LOGGER.severe("Error: There is no more events in the queue.");
        } else if (!((ConstraintEvent)event).isInitialized()) {
            this.engine.decPendingInitConstAwakeEvent();
        }
        return event;
    }

    @Override
    public boolean pushEvent(PropagationEvent event) {
        if (!this.partition.isLeft(event)) {
            this.partition.moveLeft(event);
            return true;
        }
        return false;
    }

    @Override
    public void flushEventQueue() {
        this.partition.moveAllRight();
    }

    public void add(PropagationEvent event) {
        if (this.partition.isIn(event)) {
            this.partition.moveRight(event);
        } else {
            this.partition.addRight(event);
        }
    }

    @Override
    public boolean remove(PropagationEvent event) {
        if (this.partition.isLeft(event)) {
            if (!((ConstraintEvent)event).isInitialized()) {
                this.engine.decPendingInitConstAwakeEvent();
            }
            this.partition.moveRight(event);
            return true;
        }
        return false;
    }

    @Override
    public void propagateAllEvents() throws ContradictionException {
        while (this.partition.getNbLeft() != 0) {
            this.popEvent().propagateEvent();
        }
    }

    @Override
    public void propagateOneEvent() throws ContradictionException {
        if (this.partition.getNbLeft() != 0) {
            this.popEvent().propagateEvent();
        }
    }

    @Override
    public int size() {
        return this.partition.getNbLeft();
    }

    @Override
    public PropagationEvent get(int idx) {
        Iterator<PropagationEvent> it = this.partition.leftIterator();
        while (it.hasNext()) {
            PropagationEvent event = it.next();
            if (idx == 0) {
                return event;
            }
            --idx;
        }
        return null;
    }
}

