/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.MemoryException;
import choco.kernel.memory.structure.iterators.PSVIndexIterator;
import choco.kernel.memory.structure.iterators.PSVIterator;
import java.util.Arrays;

public final class PartiallyStoredVector<E> {
    private E[] staticObjects = new Object[16];
    private E[] storedObjects = new Object[16];
    private int nStaticObjects = 0;
    private final IStateInt nStoredObjects;
    private PSVIndexIterator<E> _iterator1;
    private PSVIterator<E> _iterator2;

    public PartiallyStoredVector(IEnvironment env) {
        this.nStoredObjects = env.makeInt(0);
    }

    public void clear() {
        Arrays.fill(this.staticObjects, null);
        Arrays.fill(this.storedObjects, null);
        this.nStaticObjects = 0;
        this.nStoredObjects.set(0);
    }

    public boolean contains(Object o) {
        int i;
        for (i = 0; i < this.nStaticObjects; ++i) {
            if (!this.staticObjects[i].equals(o)) continue;
            return true;
        }
        for (i = 0; i < this.nStoredObjects.get(); ++i) {
            if (!this.storedObjects[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public int staticAdd(E o) {
        this.ensureStaticCapacity(this.nStaticObjects + 1);
        this.staticObjects[this.nStaticObjects++] = o;
        return this.nStaticObjects - 1;
    }

    public int staticInsert(int ind, E o) {
        this.ensureStaticCapacity(this.nStaticObjects++);
        System.arraycopy(this.staticObjects, ind, this.staticObjects, ind + 1, this.nStaticObjects - ind);
        this.staticObjects[ind] = o;
        return this.nStaticObjects - 1;
    }

    void staticRemove(int idx) {
        this.staticObjects[idx] = null;
        if (idx == this.nStaticObjects - 1) {
            while (this.staticObjects[this.nStaticObjects] == null && this.nStaticObjects > 0) {
                --this.nStaticObjects;
            }
            if (this.staticObjects[this.nStaticObjects] != null) {
                ++this.nStaticObjects;
            }
        }
    }

    void storedRemove(int idx) {
        this.storedObjects[idx] = null;
        if (idx == this.nStoredObjects.get() - 1) {
            while (this.storedObjects[this.nStoredObjects.get()] == null && this.nStoredObjects.get() > 0) {
                this.nStoredObjects.add(-1);
            }
            if (this.storedObjects[this.nStoredObjects.get()] != null) {
                this.nStoredObjects.add(1);
            }
        }
    }

    public int remove(Object o) {
        int i;
        for (i = 0; i < this.nStaticObjects; ++i) {
            E staticObject = this.staticObjects[i];
            if (staticObject != o) continue;
            this.staticRemove(i);
            return i;
        }
        if (this.nStoredObjects.getEnvironment().getWorldIndex() == 0) {
            for (i = 0; i < this.nStoredObjects.get(); ++i) {
                E storedObject = this.storedObjects[i];
                if (storedObject != o) continue;
                this.storedRemove(i);
                return i;
            }
        } else {
            throw new MemoryException("impossible to remove the object (a constraint ?) from the dynamic part of the collection (root node ?)");
        }
        throw new MemoryException("impossible to remove the object (a constraint ?) from the static part of the collection (cut manager ?)");
    }

    void ensureStaticCapacity(int n) {
        if (n >= this.staticObjects.length) {
            int newSize = this.staticObjects.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            Object[] newStaticObjects = new Object[newSize];
            System.arraycopy(this.staticObjects, 0, newStaticObjects, 0, this.staticObjects.length);
            this.staticObjects = newStaticObjects;
        }
    }

    public int add(E o) {
        this.ensureStoredCapacity(this.nStoredObjects.get() + 1);
        this.storedObjects[this.nStoredObjects.get()] = o;
        this.nStoredObjects.add(1);
        return 1000000 + this.nStoredObjects.get() - 1;
    }

    public int insert(int ind, E o) {
        this.ensureStoredCapacity(this.nStoredObjects.get() + 1);
        System.arraycopy(this.storedObjects, ind, this.storedObjects, ind + 1, this.nStoredObjects.get() - ind);
        this.storedObjects[ind] = o;
        this.nStoredObjects.add(1);
        return 1000000 + this.nStoredObjects.get() - 1;
    }

    void ensureStoredCapacity(int n) {
        if (n >= this.storedObjects.length) {
            int newSize = this.storedObjects.length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            Object[] newStoredObjects = new Object[newSize];
            System.arraycopy(this.storedObjects, 0, newStoredObjects, 0, this.storedObjects.length);
            this.storedObjects = newStoredObjects;
        }
    }

    public E get(int index) {
        if (index < 1000000) {
            return this.staticObjects[index];
        }
        return this.storedObjects[index - 1000000];
    }

    public boolean isEmpty() {
        return this.nStaticObjects == 0 && this.nStoredObjects.get() == 0;
    }

    public int size() {
        return this.nStaticObjects + this.nStoredObjects.get();
    }

    public DisposableIntIterator getIndexIterator() {
        if (this._iterator1 == null) {
            this._iterator1 = new PSVIndexIterator();
        } else if (!this._iterator1.reusable()) {
            assert (false);
            this._iterator1 = new PSVIndexIterator();
        }
        this._iterator1.init(this.nStaticObjects, this.staticObjects, this.nStoredObjects);
        return this._iterator1;
    }

    public DisposableIterator getIterator() {
        if (this._iterator2 == null) {
            this._iterator2 = new PSVIterator();
        } else if (!this._iterator2.reusable()) {
            assert (false);
            this._iterator2 = new PSVIterator();
        }
        this._iterator2.init(this.nStaticObjects, this.staticObjects, this.nStoredObjects, this.storedObjects);
        return this._iterator2;
    }

    public static boolean isStaticIndex(int idx) {
        return idx < 1000000;
    }

    public static int getSmallIndex(int idx) {
        if (idx < 1000000) {
            return idx;
        }
        return idx - 1000000;
    }

    public static int getGlobalIndex(int idx, boolean isStatic) {
        if (isStatic) {
            return idx;
        }
        return idx + 1000000;
    }

    public int getLastStaticIndex() {
        return this.nStaticObjects - 1;
    }

    public static int getFirstStaticIndex() {
        return 0;
    }

    public int getLastStoredIndex() {
        return this.nStoredObjects.get() - 1;
    }
}

