/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.text.NumberFormat;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.vikamine.kernel.Describable;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.statistics.StatisticComponent;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.functions.LiftQF;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class XMLSGPatternExport {
    public static Document getXML(SGSet sgs, Ontology onto) {
        return XMLSGPatternExport.getXML(sgs, onto, null, null);
    }

    public static Document getXML(SGSet sgs, Ontology onto, String title, String creator) {
        return XMLSGPatternExport.getXML(sgs, onto, onto.getTripleStore().getStatements(onto, OntologyConstants.DATASET_FILE_NAME_PROPERTY, "**ANY_OBJECT**").toString(), title, creator);
    }

    public static Document getXML(SGSet sgs, Ontology onto, String datasetName, String title, String creator) {
        Element dc;
        if (sgs == null) {
            throw new IllegalArgumentException("cannot write NULL SGSet!");
        }
        Element patternSet = new Element("patternSet");
        Namespace n2 = Namespace.getNamespace("dc", "http://purl.org/dc/elements/1.1/");
        patternSet.setNamespace(Namespace.NO_NAMESPACE);
        patternSet.addNamespaceDeclaration(n2);
        if (title != null && !title.equals("")) {
            dc = new Element("title");
            dc.setNamespace(n2);
            dc.addContent(title);
            patternSet.addContent(dc);
        }
        if (creator != null && creator.equals("")) {
            dc = new Element("creator");
            dc.setNamespace(n2);
            dc.addContent(creator);
            patternSet.addContent(dc);
        }
        dc = new Element("date");
        dc.setNamespace(n2);
        dc.addContent(GregorianCalendar.getInstance().getTime().toString());
        patternSet.addContent(dc);
        if (onto != null) {
            patternSet.addContent(XMLSGPatternExport.getDatasetElement(onto, datasetName));
        }
        patternSet.setAttribute("dataset", datasetName);
        for (SG sg : sgs) {
            Element subgroupPattern = new Element("subgroupPattern");
            Element description = new Element("description");
            Element operator = new Element("operator");
            Element target = new Element("target");
            operator.setAttribute("type", "and");
            Element parameters = new Element("parameters");
            if (sg.getTarget() != null) {
                if (sg.getTarget().isBoolean()) {
                    target.setAttribute("type", "boolean");
                } else {
                    target.setAttribute("type", "numeric");
                }
                Iterator<Describable> it = sg.getTarget().getAttributes().iterator();
                while (it.hasNext()) {
                    Element att = new Element("attribute");
                    String name = ((Attribute)it.next()).getDescription();
                    try {
                        try {
                            Element include = new Element("includeValue");
                            include.setText(sg.getTarget().getDescription().split(String.valueOf(name) + "=")[1].replace(")", ""));
                            att.addContent(include);
                        }
                        catch (IndexOutOfBoundsException include) {
                            att.setAttribute("name", name);
                            target.addContent(att);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        att.setAttribute("name", name);
                        target.addContent(att);
                        throw throwable;
                    }
                    att.setAttribute("name", name);
                    target.addContent(att);
                }
            } else {
                target.setAttribute("type", "");
            }
            for (SGNominalSelector sele : sg.getSGDescription()) {
                Element att = new Element("attribute");
                att.setAttribute("name", sele.getAttribute().getDescription());
                for (Value k : sele.getValues()) {
                    Element include = new Element("includeValue");
                    include.setText(k.getDescription());
                    att.addContent(include);
                }
                operator.addContent(att);
            }
            NumberFormat n = NumberFormat.getInstance();
            n.setMaximumFractionDigits(2);
            Element param = new Element("parameter");
            param.setAttribute("name", "quality");
            param.setAttribute("value", String.valueOf(n.format(sg.getQuality())));
            parameters.addContent(param);
            param = new Element("parameter");
            param.setAttribute("name", "populationSize");
            param.setAttribute("value", String.valueOf((int)sg.getStatistics().getDefinedPopulationCount()));
            parameters.addContent(param);
            param = new Element("parameter");
            param.setAttribute("name", "subgroupSize");
            param.setAttribute("value", String.valueOf((int)sg.getStatistics().getSubgroupSize()));
            parameters.addContent(param);
            if (sg.getTarget().isBoolean()) {
                param = new Element("parameter");
                param.setAttribute("name", "TP");
                param.setAttribute("value", String.valueOf((int)((SGStatisticsBinary)sg.getStatistics()).getTp()));
                parameters.addContent(param);
                param = new Element("parameter");
                param.setAttribute("name", "FP");
                param.setAttribute("value", String.valueOf((int)((SGStatisticsBinary)sg.getStatistics()).getFp()));
                parameters.addContent(param);
                StatisticComponent.P p = new StatisticComponent.P();
                param = new Element("parameter");
                param.setAttribute("name", "target/subgroup");
                param.setAttribute("value", p.getValue(sg.getStatistics()).toString());
                parameters.addContent(param);
                StatisticComponent.P0 po = new StatisticComponent.P0();
                param = new Element("parameter");
                param.setAttribute("name", "target/population");
                param.setAttribute("value", po.getValue(sg.getStatistics()).toString());
                parameters.addContent(param);
                StatisticComponent.TPRate t = new StatisticComponent.TPRate();
                param = new Element("parameter");
                param.setAttribute("name", "TP-Rate");
                param.setAttribute("value", t.getValue(sg.getStatistics()).toString());
                parameters.addContent(param);
                StatisticComponent.Coverage c = new StatisticComponent.Coverage();
                param = new Element("parameter");
                param.setAttribute("name", "coverage");
                param.setAttribute("value", c.getValue(sg.getStatistics()));
                parameters.addContent(param);
                StatisticComponent.Significance s = new StatisticComponent.Significance();
                param = new Element("parameter");
                param.setAttribute("name", "significance");
                param.setAttribute("value", s.getValue(sg.getStatistics()).toString());
                parameters.addContent(param);
            }
            n.setMaximumFractionDigits(3);
            param = new Element("parameter");
            param.setAttribute("name", "lift");
            param.setAttribute("value", String.valueOf(n.format(XMLSGPatternExport.computeLift(sg.getStatistics()))));
            parameters.addContent(param);
            description.setContent(operator);
            subgroupPattern.addContent(target);
            subgroupPattern.addContent(description);
            subgroupPattern.addContent(parameters);
            patternSet.addContent(subgroupPattern);
        }
        Document doc = new Document(patternSet);
        return doc;
    }

    private static Object computeLift(SGStatistics stats) {
        if (stats instanceof SGStatisticsBinary) {
            SGStatisticsBinary binary = (SGStatisticsBinary)stats;
            return LiftQF.computeLiftBinary(binary.getP(), binary.getSubgroupSize(), binary.getP0(), binary.getDefinedPopulationCount());
        }
        if (stats instanceof SGStatisticsNumeric) {
            SGStatisticsNumeric numeric = (SGStatisticsNumeric)stats;
            return LiftQF.computeLiftNumeric(numeric.getSGMean(), numeric.getPopulationMean());
        }
        throw new IllegalStateException("Unknown SGStatistics!" + stats);
    }

    private static Element getDatasetElement(Ontology onto, String datasetName) {
        Element dataset = new Element("dataset");
        dataset.setAttribute("name", datasetName);
        DataView pop = onto.getDataView();
        if (!pop.populationRangesSelectors().isEmpty()) {
            Element restrictions = new Element("restrictions");
            for (SGSelector selector : pop.populationRangesSelectors()) {
                if (selector instanceof DefaultSGSelector) {
                    Attribute att = selector.getAttribute();
                    Element attrElement = new Element("attribute");
                    attrElement.setAttribute("name", att.getId());
                    Set<Value> values = ((DefaultSGSelector)selector).getValues();
                    for (Value val : values) {
                        Element inclElement = new Element("includeValue");
                        inclElement.setText(val.getDescription());
                        attrElement.addContent(inclElement);
                    }
                    restrictions.addContent(attrElement);
                    continue;
                }
                if (selector instanceof NegatedSGSelector) {
                    SGNominalSelector posSelector = ((NegatedSGSelector)selector).getPositiveSelector();
                    if (!(posSelector instanceof DefaultSGSelector)) {
                        throw new IllegalArgumentException("Unsupported DataView restriction for XML-output!");
                    }
                    Attribute att = selector.getAttribute();
                    Element attrElement = new Element("attribute");
                    attrElement.setAttribute("name", att.getId());
                    Set<Value> values = posSelector.getValues();
                    for (Value val : values) {
                        Element inclElement = new Element("excludeValue");
                        inclElement.setText(val.getDescription());
                        attrElement.addContent(inclElement);
                    }
                    restrictions.addContent(attrElement);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported DataView restriction for XML-output!");
            }
            dataset.addContent(restrictions);
        }
        return dataset;
    }
}

