/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

public class MatrixInfo {
    private boolean sparse;
    private MatrixField field;
    private MatrixSymmetry symmetry;

    public MatrixInfo(boolean bl, MatrixField matrixField, MatrixSymmetry matrixSymmetry) {
        this.sparse = bl;
        this.field = matrixField;
        this.symmetry = matrixSymmetry;
        this.validate();
    }

    private void validate() {
        if (this.isDense() && this.isPattern()) {
            throw new IllegalArgumentException("Matrix cannot be dense with pattern storage");
        }
        if (this.isReal() && this.isHermitian()) {
            throw new IllegalArgumentException("Data cannot be real with hermitian symmetry");
        }
        if (!this.isComplex() && this.isHermitian()) {
            throw new IllegalArgumentException("Data must be complex with hermitian symmetry");
        }
        if (this.isPattern() && this.isSkewSymmetric()) {
            throw new IllegalArgumentException("Storage cannot be pattern and skew symmetrical");
        }
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean isCoordinate() {
        return this.sparse;
    }

    public boolean isDense() {
        return !this.sparse;
    }

    public boolean isArray() {
        return !this.sparse;
    }

    public boolean isReal() {
        return this.field == MatrixField.Real;
    }

    public boolean isInteger() {
        return this.field == MatrixField.Integer;
    }

    public boolean isComplex() {
        return this.field == MatrixField.Complex;
    }

    public boolean isPattern() {
        return this.field == MatrixField.Pattern;
    }

    public boolean isGeneral() {
        return this.symmetry == MatrixSymmetry.General;
    }

    public boolean isSymmetric() {
        return this.symmetry == MatrixSymmetry.Symmetric;
    }

    public boolean isSkewSymmetric() {
        return this.symmetry == MatrixSymmetry.SkewSymmetric;
    }

    public boolean isHermitian() {
        return this.symmetry == MatrixSymmetry.Hermitian;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("%%MatrixMarket matrix ");
        if (this.isSparse()) {
            stringBuilder.append("coordinate ");
        } else {
            stringBuilder.append("array ");
        }
        if (this.isReal()) {
            stringBuilder.append("real ");
        } else if (this.isComplex()) {
            stringBuilder.append("complex ");
        } else if (this.isPattern()) {
            stringBuilder.append("pattern ");
        } else if (this.isInteger()) {
            stringBuilder.append("integer ");
        } else {
            throw new IllegalArgumentException("Unknown field specification");
        }
        if (this.isGeneral()) {
            stringBuilder.append("general\n");
        } else if (this.isSymmetric()) {
            stringBuilder.append("symmetric\n");
        } else if (this.isSkewSymmetric()) {
            stringBuilder.append("skew-symmetric\n");
        } else if (this.isHermitian()) {
            stringBuilder.append("Hermitian\n");
        } else {
            throw new IllegalArgumentException("Unknown symmetry specification");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatrixSymmetry {
        General,
        Symmetric,
        SkewSymmetric,
        Hermitian;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatrixField {
        Real,
        Integer,
        Complex,
        Pattern;

    }
}

