/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.Periodogram;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatisticalTest;

public class PeriodogramTest {
    private static final double D = 0.01;

    public static StatisticalTest computeSum(IReadDataBlock data, int freq) {
        Periodogram periodogram = new Periodogram(data, false);
        double[] seasfreqs = new double[(freq - 1) / 2];
        for (int i = 0; i < seasfreqs.length; ++i) {
            seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)freq;
        }
        double[] p = periodogram.getS();
        double xsum = 0.0;
        double dstep = periodogram.getIntervalInRadians();
        double estep = dstep * 0.01;
        int nf = 0;
        for (int i = 0; i < seasfreqs.length; ++i) {
            double f = seasfreqs[i];
            int j = (int)(seasfreqs[i] / dstep);
            if (f - (double)(j - 1) * dstep < estep) {
                nf += 2;
                xsum += p[j - 1];
            }
            if (f - (double)j * dstep < estep) {
                nf += 2;
                xsum += p[j];
            }
            if (!((double)(j + 1) * dstep - f < estep)) continue;
            nf += 2;
            xsum += p[j + 1];
        }
        if (freq % 2 == 0) {
            ++nf;
            xsum += p[p.length - 1];
        }
        Chi2 chi2 = new Chi2();
        chi2.setDegreesofFreedom(nf);
        return new StatisticalTest(chi2, xsum, TestType.Upper, true);
    }

    public static IReadDataBlock expand(IReadDataBlock data, int freq) {
        int n = data.getLength();
        if (n % freq == 0) {
            return data;
        }
        double[] nd = new double[(1 + n / freq) * freq];
        data.copyTo(nd, 0);
        return new ReadDataBlock(nd);
    }

    public static IReadDataBlock shrink(IReadDataBlock data, int freq) {
        int n = data.getLength();
        if (n % freq == 0) {
            return data;
        }
        int nc = n - n % freq;
        double[] nd = new double[nc];
        data.rextract(n - nc, nc).copyTo(nd, 0);
        return new ReadDataBlock(nd);
    }

    public static StatisticalTest computeSum2(IReadDataBlock data, int freq) {
        int n = (data = PeriodogramTest.shrink(data, freq)).getLength();
        if (n < 3 * freq) {
            return null;
        }
        Periodogram periodogram = new Periodogram(data, false);
        double[] p = periodogram.getP();
        double xsum = 0.0;
        int f2 = (freq - 1) / 2;
        int nf = 2 * f2;
        int m = n / freq;
        for (int i = 1; i <= f2; ++i) {
            xsum += p[i * m];
        }
        if (freq % 2 == 0) {
            ++nf;
            xsum += p[p.length - 1];
        }
        F f = new F();
        f.setDFNum(nf);
        f.setDFDenom(n - nf - 1);
        double val = (double)(n - nf - 1) * xsum / ((double)n - xsum - p[0]) / (double)nf;
        return new StatisticalTest(f, val, TestType.Upper, true);
    }

    public static double computeMax(IReadDataBlock data, int freq) {
        Periodogram periodogram = new Periodogram(data, false);
        double[] seasfreqs = new double[(freq - 1) / 2];
        for (int i = 0; i < seasfreqs.length; ++i) {
            seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)freq;
        }
        double[] p = periodogram.getS();
        double xmax = 0.0;
        double dstep = periodogram.getIntervalInRadians();
        double estep = dstep * 0.01;
        int nf = 0;
        for (int i = 0; i < seasfreqs.length; ++i) {
            double f = seasfreqs[i];
            int j = (int)(seasfreqs[i] / dstep);
            if (f - (double)(j - 1) * dstep < estep) {
                ++nf;
                xmax = Math.max(xmax, p[j - 1]);
            }
            if (f - (double)j * dstep < estep) {
                ++nf;
                xmax = Math.max(xmax, p[j]);
            }
            if (!((double)(j + 1) * dstep - f < estep)) continue;
            ++nf;
            xmax = Math.max(xmax, p[j + 1]);
        }
        return 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), nf);
    }
}

