## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(patchwork)

## -----------------------------------------------------------------------------
library(ggplot2)
p1 <- ggplot(mtcars) + 
  geom_point(aes(mpg, disp)) + 
  ggtitle('Plot 1')

p2 <- ggplot(mtcars) + 
  geom_boxplot(aes(gear, disp, group = gear)) + 
  ggtitle('Plot 2')

p3 <- ggplot(mtcars) + 
  geom_point(aes(hp, wt, colour = mpg)) + 
  ggtitle('Plot 3')

p4 <- ggplot(mtcars) + 
  geom_bar(aes(gear)) + 
  facet_wrap(~cyl) + 
  ggtitle('Plot 4')

## -----------------------------------------------------------------------------
p1 + p2

## -----------------------------------------------------------------------------
p1 + p2 + labs(subtitle = 'This will appear in the last plot')

## -----------------------------------------------------------------------------
p1 + p2 + p3 + p4

## -----------------------------------------------------------------------------
p1 + p2 + p3 + p4 + plot_layout(nrow = 3, byrow = FALSE)

## -----------------------------------------------------------------------------
p1 / p2

## -----------------------------------------------------------------------------
p1 | (p2 / p3)

## -----------------------------------------------------------------------------
(p1 | (p2 / p3)) + 
  plot_annotation(title = 'The surprising story about mtcars')

## -----------------------------------------------------------------------------
p1 + p2 + p3 + 
  plot_annotation(tag_levels = 'I')

