/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import java.util.Iterator;
import org.openscience.cdk.tools.diff.tree.AbstractDifferenceList;
import org.openscience.cdk.tools.diff.tree.BooleanDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IDifferenceList;

public class BooleanArrayDifference
extends AbstractDifferenceList
implements IDifferenceList {
    private final String name;

    private BooleanArrayDifference(String name) {
        this.name = name;
    }

    public static IDifference construct(String name, boolean[] first, boolean[] second) {
        int secondLength;
        if (first == null && second == null) {
            return null;
        }
        BooleanArrayDifference totalDiff = new BooleanArrayDifference(name);
        int firstLength = first == null ? 0 : first.length;
        int n = secondLength = second == null ? 0 : second.length;
        if (firstLength == secondLength) {
            for (int i = 0; i < firstLength; ++i) {
                totalDiff.addChild(BooleanDifference.construct("" + i, first[i], second[i]));
            }
        } else if (firstLength < secondLength) {
            int i;
            for (i = 0; i < firstLength; ++i) {
                totalDiff.addChild(BooleanDifference.construct("" + i, first[i], second[i]));
            }
            for (i = firstLength; i < secondLength; ++i) {
                totalDiff.addChild(BooleanDifference.construct("" + i, null, second[i]));
            }
        } else {
            int i;
            for (i = 0; i < secondLength; ++i) {
                totalDiff.addChild(BooleanDifference.construct("" + i, first[i], second[i]));
            }
            for (i = secondLength; i < firstLength; ++i) {
                totalDiff.addChild(BooleanDifference.construct("" + i, first[i], null));
            }
        }
        if (totalDiff.childCount() == 0) {
            return null;
        }
        return totalDiff;
    }

    public String toString() {
        if (this.differences.size() == 0) {
            return "";
        }
        StringBuilder diffBuffer = new StringBuilder();
        diffBuffer.append(this.name).append('{');
        Iterator<IDifference> children = this.getChildren().iterator();
        while (children.hasNext()) {
            diffBuffer.append(children.next().toString());
            if (!children.hasNext()) continue;
            diffBuffer.append(", ");
        }
        diffBuffer.append('}');
        return diffBuffer.toString();
    }
}

