/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

final class NormaliseDirectionalLabels
extends AbstractFunction<Graph, Graph> {
    NormaliseDirectionalLabels() {
    }

    public Graph apply(Graph g) {
        int u;
        Traversal traversal = new Traversal(g);
        Graph h = new Graph(g.order());
        h.addFlags(g.getFlags(-1));
        for (u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        for (u = 0; u < g.order(); ++u) {
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = g.edgeAt(u, j);
                if (e.other(u) <= u) continue;
                if (traversal.acc.containsKey(e)) {
                    h.addEdge((Edge)traversal.acc.get(e));
                    continue;
                }
                h.addEdge(e);
            }
        }
        return h.sort((Graph.EdgeComparator)new Graph.CanOrderFirst());
    }

    private static final class Traversal {
        private final Graph g;
        private final boolean[] visited;
        private final int[] ordering;
        private int i;
        private Map<Edge, Edge> acc = new HashMap<Edge, Edge>();
        private List<Edge> doubleBonds = new ArrayList<Edge>();
        private Set<Integer> adj = new HashSet<Integer>();

        private Traversal(Graph g) {
            this.g = g;
            this.visited = new boolean[g.order()];
            this.ordering = new int[g.order()];
            BitSet dbAtoms = new BitSet();
            for (int u = 0; u < g.order(); ++u) {
                if (this.visited[u]) continue;
                dbAtoms.or(this.visit(u, u));
            }
            Collections.sort(this.doubleBonds, new Comparator<Edge>(){

                @Override
                public int compare(Edge e, Edge f) {
                    int min2;
                    int u1 = e.either();
                    int v1 = e.other(u1);
                    int u2 = f.either();
                    int v2 = f.other(u2);
                    int min1 = Math.min(ordering[u1], ordering[v1]);
                    int cmp = min1 - (min2 = Math.min(ordering[u2], ordering[v2]));
                    if (cmp != 0) {
                        return cmp;
                    }
                    int max1 = Math.max(ordering[u1], ordering[v1]);
                    int max2 = Math.max(ordering[u2], ordering[v2]);
                    return max1 - max2;
                }
            });
            for (Edge e : this.doubleBonds) {
                if (this.acc.containsKey(e)) continue;
                this.flip(g, e, dbAtoms);
            }
        }

        private BitSet visit(int p, int u) {
            this.visited[u] = true;
            ++this.i;
            BitSet dbAtoms = new BitSet();
            int d = this.g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = this.g.edgeAt(u, j);
                int v = e.other(u);
                if (v == p) continue;
                if (e.bond().order() == 2 && this.hasAdjDirectionalLabels(this.g, e)) {
                    dbAtoms.set(u);
                    dbAtoms.set(v);
                    boolean newSystem = !this.adj.contains(u) && !this.adj.contains(v);
                    int d2 = this.g.degree(u);
                    for (int j2 = 0; j2 < d2; ++j2) {
                        this.adj.add(this.g.edgeAt(u, j2).other(u));
                    }
                    int d3 = this.g.degree(v);
                    for (int j2 = 0; j2 < d3; ++j2) {
                        this.adj.add(this.g.edgeAt(v, j2).other(v));
                    }
                    this.doubleBonds.add(e);
                }
                if (this.visited[v]) continue;
                dbAtoms.or(this.visit(u, v));
            }
            return dbAtoms;
        }

        private boolean hasAdjDirectionalLabels(Graph g, Edge e) {
            int u = e.either();
            int v = e.other(u);
            return this.hasAdjDirectionalLabels(g, u) && this.hasAdjDirectionalLabels(g, v);
        }

        private boolean hasAdjDirectionalLabels(Graph g, int u) {
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f = g.edgeAt(u, j);
                if (!f.bond().directional()) continue;
                return true;
            }
            return false;
        }

        private void flip(Graph g, Edge e, BitSet dbAtoms) {
            int v;
            int u = e.either();
            if (this.ordering[u] < this.ordering[v = e.other(u)]) {
                Edge first = this.firstDirectionalLabel(g, u);
                if (first != null) {
                    this.flip(first, u, dbAtoms);
                } else {
                    first = this.firstDirectionalLabel(g, v);
                    this.flip(first, v, dbAtoms);
                }
            } else {
                Edge first = this.firstDirectionalLabel(g, v);
                if (first != null) {
                    this.flip(first, v, dbAtoms);
                } else {
                    first = this.firstDirectionalLabel(g, u);
                    this.flip(first, u, dbAtoms);
                }
            }
        }

        private void flip(Edge first, int u, BitSet dbAtoms) {
            if (first == null) {
                return;
            }
            if (this.ordering[first.other(u)] < this.ordering[u]) {
                if (first.bond(u) == Bond.UP) {
                    this.invertExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
                } else {
                    this.markExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
                }
            } else if (first.bond(u) == Bond.DOWN) {
                this.invertExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
            } else {
                this.markExistingDirectionalLabels(this.g, u, new BitSet(), this.acc, dbAtoms, u);
            }
        }

        Edge firstDirectionalLabel(Graph g, int u) {
            Edge first = null;
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f = g.edgeAt(u, j);
                if (f.bond() != Bond.UP && f.bond() != Bond.DOWN || first != null && this.ordering[f.other(u)] >= this.ordering[first.other(u)]) continue;
                first = f;
            }
            return first;
        }

        private void invertExistingDirectionalLabels(Graph g, int prev, BitSet visited, Map<Edge, Edge> replacement, BitSet dbAtoms, int u) {
            visited.set(u);
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f;
                Edge e = g.edgeAt(u, j);
                int v = e.other(u);
                if (v == prev || (f = replacement.get(e)) != null) continue;
                replacement.put(e, e.inverse());
                if (visited.get(v) || !dbAtoms.get(v)) continue;
                this.invertExistingDirectionalLabels(g, u, visited, replacement, dbAtoms, v);
            }
        }

        private void markExistingDirectionalLabels(Graph g, int prev, BitSet visited, Map<Edge, Edge> replacement, BitSet dbAtoms, int u) {
            visited.set(u);
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge f;
                Edge e = g.edgeAt(u, j);
                int v = e.other(u);
                if (v == prev || (f = replacement.get(e)) != null) continue;
                replacement.put(e, e);
                if (visited.get(v) || !dbAtoms.get(v)) continue;
                this.markExistingDirectionalLabels(g, u, visited, replacement, dbAtoms, v);
            }
        }
    }
}

