/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.lex;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;

@Explained(ignored=true, comment="Decomposed into arithmetic constraints")
public class PropIncreasing
extends Propagator<IntVar> {
    private final int strict;
    private int left;
    private int right;

    public PropIncreasing(IntVar[] vars, int strict) {
        super((Variable[])vars, (Priority)PropagatorPriority.LINEAR, true);
        this.strict = strict;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
                ((IntVar[])this.vars)[i + 1].updateLowerBound(((IntVar[])this.vars)[i].getLB() + this.strict, (ICause)this);
            }
            for (int j = ((IntVar[])this.vars).length - 1; j > 0; --j) {
                ((IntVar[])this.vars)[j - 1].updateUpperBound(((IntVar[])this.vars)[j].getUB() - this.strict, (ICause)this);
            }
            this.left = ((IntVar[])this.vars).length - 1;
            this.right = 0;
        } else {
            this.left = ((IntVar[])this.vars).length - 1;
            int j = this.right;
            this.right = 0;
            for (int i = this.left; i < ((IntVar[])this.vars).length - 1; ++i) {
                ((IntVar[])this.vars)[i + 1].updateLowerBound(((IntVar[])this.vars)[i].getLB() + this.strict, (ICause)this);
            }
            while (j > 0) {
                ((IntVar[])this.vars)[j - 1].updateUpperBound(((IntVar[])this.vars)[j].getUB() - this.strict, (ICause)this);
                --j;
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            this.left = Math.min(this.left, idxVarInProp);
            this.right = Math.max(this.right, idxVarInProp);
        } else if (IntEventType.isInclow(mask)) {
            this.left = Math.min(this.left, idxVarInProp);
        } else if (IntEventType.isDecupp(mask)) {
            this.right = Math.max(this.right, idxVarInProp);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        int cnt = 0;
        for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
            if (((IntVar[])this.vars)[i].getUB() + this.strict <= ((IntVar[])this.vars)[i + 1].getLB()) {
                ++cnt;
                continue;
            }
            if (((IntVar[])this.vars)[i].getLB() + this.strict <= ((IntVar[])this.vars)[i + 1].getUB()) continue;
            return ESat.FALSE;
        }
        return cnt == ((IntVar[])this.vars).length - 1 ? ESat.TRUE : ESat.UNDEFINED;
    }
}

