/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.propagation.PropagationInsight;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.queues.CircularQueue;
import org.chocosolver.util.tools.ArrayUtils;

public class PropagationEngine {
    public static boolean CHECK_SCOPE = false;
    final Model model;
    final MiniSat sat;
    final List<Propagator<?>> propagators;
    private final DynPropagators dynPropagators;
    private final CircularQueue<Propagator<?>>[] pro_queue;
    private final CircularQueue<Variable> var_queue;
    private final CircularQueue<Propagator<?>> awake_queue;
    protected Propagator<?> lastProp;
    protected Variable lastVar;
    private int notEmpty;
    private int delayedPropagationType;
    private boolean init;
    private byte hybrid;
    private final Consumer<Propagator<?>> consumer = new Consumer<Propagator<?>>(){

        @Override
        public void accept(Propagator propagator) {
            PropagationEngine.this.awake_queue.addLast(propagator);
        }
    };
    private PropagationInsight insight = PropagationInsight.VOID;

    public PropagationEngine(Model model, MiniSat sat) {
        this.model = model;
        int nbQueues = model.getSettings().getMaxPropagatorPriority() + 1;
        this.pro_queue = new CircularQueue[nbQueues];
        for (int i = 0; i < nbQueues; ++i) {
            this.pro_queue[i] = new CircularQueue(16);
        }
        this.var_queue = new CircularQueue(16);
        this.awake_queue = new CircularQueue(16);
        this.dynPropagators = new DynPropagators();
        this.propagators = new ArrayList();
        this.hybrid = model.getSettings().enableHybridizationOfPropagationEngine();
        this.sat = sat;
    }

    public PropagationEngine(Model model) {
        this(model, null);
    }

    public void initialize() throws SolverException {
        if (!this.init) {
            Constraint[] constraints;
            this.notEmpty = 0;
            this.init = true;
            while (!this.var_queue.isEmpty()) {
                this.var_queue.pollFirst().clearEvents();
            }
            for (Constraint constraint : constraints = this.model.getCstrs()) {
                Propagator[] cprops = constraint.getPropagators();
                Collections.addAll(this.propagators, cprops);
            }
            if (this.model.getSettings().sortPropagatorActivationWRTPriority()) {
                this.propagators.sort((p1, p2) -> {
                    int p = p1.getPriority().getValue() - p2.getPriority().getValue();
                    if (p == 0) {
                        return p1.getNbVars() - p2.getNbVars();
                    }
                    return p;
                });
            }
            for (int i = 0; i < this.propagators.size(); ++i) {
                Propagator<?> propagator = this.getPropagator(i);
                this.awake_queue.addLast(propagator);
            }
        }
    }

    private Propagator<?> getPropagator(int i) {
        Propagator<?> propagator = this.propagators.get(i);
        if (propagator.getPriority().getValue() >= this.pro_queue.length) {
            throw new SolverException(propagator + "\nThis propagator declares a priority (" + propagator.getPriority() + ") whose value (" + propagator.getPriority().getValue() + ") is greater than the maximum allowed priority (" + this.model.getSettings().getMaxPropagatorPriority() + ").\nEither increase the maximum allowed priority (`Model model = new Model(Settings.init().setMaxPropagatorPriority(" + (propagator.getPriority().getValue() + 1) + "));`)  or decrease the propagator priority.");
        }
        propagator.setPosition(i);
        return propagator;
    }

    public boolean isInitialized() {
        return this.init;
    }

    public void propagate() throws ContradictionException {
        this.propagateSat();
        this.insight.clear();
        this.activatePropagators();
        do {
            this.manageModifications();
            int i = this.nextNotEmpty();
            while (i > -1) {
                assert (!this.pro_queue[i].isEmpty()) : "try to pop a propagator from an empty queue";
                this.lastProp = this.pro_queue[i].pollFirst();
                this.insight.cardinality(this.lastProp);
                if (this.pro_queue[i].isEmpty()) {
                    this.notEmpty &= ~(1 << i);
                }
                this.lastProp.unschedule();
                this.delayedPropagationType = 0;
                try {
                    this.propagateEvents();
                    this.propagateSat();
                    this.insight.update(this.lastProp, this.lastVar, false);
                }
                catch (ContradictionException cex) {
                    this.insight.update(this.lastProp, this.lastVar, true);
                    throw cex;
                }
                if (this.hybrid < 1) {
                    this.manageModifications();
                }
                i = this.nextNotEmpty();
            }
        } while (!this.var_queue.isEmpty());
    }

    private void propagateSat() throws ContradictionException {
        if (this.sat != null) {
            this.model.getSolver().getMeasures().incPropagationCount();
            this.sat.propagate();
            if (this.sat.confl != MiniSat.C_Undef) {
                this.model.getSolver().throwsException(Cause.Sat, null, null);
            }
        }
    }

    protected void propagateEvents() throws ContradictionException {
        if (this.lastProp.reactToFineEvent()) {
            this.model.getSolver().getMeasures().incPropagationCount();
            this.lastProp.doFinePropagation();
            if (this.delayedPropagationType > 0) {
                this.lastProp.propagate(this.delayedPropagationType);
            }
        } else if (this.lastProp.isActive()) {
            this.model.getSolver().getMeasures().incPropagationCount();
            this.lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
        }
    }

    private void activatePropagators() throws ContradictionException {
        int cw = this.model.getEnvironment().getWorldIndex();
        this.dynPropagators.descending(cw, this.consumer);
        while (!this.awake_queue.isEmpty()) {
            this.execute(this.awake_queue.pollFirst());
        }
    }

    public void execute(Propagator<?> propagator) throws ContradictionException {
        if (propagator.isStateLess()) {
            propagator.setActive();
        }
        if (propagator.isActive()) {
            this.model.getSolver().getMeasures().incPropagationCount();
            propagator.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            this.model.getSolver().getMeasures().incPropagationCount();
            this.propagateSat();
            while (!this.var_queue.isEmpty()) {
                this.var_queue.pollFirst().schedulePropagators(this);
            }
        }
    }

    private void manageModifications() {
        if (!this.var_queue.isEmpty()) {
            do {
                this.var_queue.pollFirst().schedulePropagators(this);
            } while (this.hybrid < 2 && !this.var_queue.isEmpty());
        }
    }

    private int nextNotEmpty() {
        if (this.notEmpty == 0) {
            return -1;
        }
        return Integer.numberOfTrailingZeros(this.notEmpty);
    }

    public void flush() {
        if (this.lastProp != null) {
            this.lastProp.doFlush();
        }
        while (!this.var_queue.isEmpty()) {
            this.var_queue.pollLast().clearEvents();
        }
        int i = this.nextNotEmpty();
        while (i > -1) {
            while (!this.pro_queue[i].isEmpty()) {
                this.pro_queue[i].pollLast().doFlush();
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty();
        }
        this.lastProp = null;
        this.lastVar = null;
    }

    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) {
        if (CHECK_SCOPE && Propagator.class.isAssignableFrom(cause.getClass())) {
            Propagator p = (Propagator)cause;
            boolean found = false;
            for (int i = 0; i < p.getNbVars() && !found; ++i) {
                found = p.getVar(i) == variable;
            }
            assert (found) : variable + " not in scope of " + cause;
        }
        this.insight.modifiy(variable);
        if (!variable.isScheduled()) {
            this.var_queue.addLast(variable);
            variable.schedule();
        }
        variable.storeEvents(type.getMask(), cause);
    }

    public void schedule(Propagator<?> prop, int pindice, int mask) {
        prop.doScheduleEvent(pindice, mask);
        this.notEmpty |= 1 << prop.doSchedule(this.pro_queue);
    }

    public void delayedPropagation(Propagator<?> propagator, PropagatorEventType type) {
        assert (propagator == this.lastProp);
        assert (this.delayedPropagationType == 0 || this.delayedPropagationType == type.getMask());
        this.delayedPropagationType = type.getMask();
    }

    int getDelayedPropagation() {
        return this.delayedPropagationType;
    }

    public void onPropagatorExecution(Propagator<?> propagator) {
        this.deactivatePropagator(propagator);
    }

    public void deactivatePropagator(Propagator<?> propagator) {
        if (propagator.reactToFineEvent()) {
            propagator.doFlush();
        }
    }

    public void setInsight(PropagationInsight insight) {
        this.insight = insight;
    }

    public void setHybrid(byte hybrid) {
        this.hybrid = hybrid;
    }

    public void reset() {
        this.flush();
        this.clear();
    }

    public void clear() {
        this.dynPropagators.clear();
        this.awake_queue.clear();
        this.propagators.clear();
        this.notEmpty = 0;
        this.init = false;
        this.lastProp = null;
        this.lastVar = null;
    }

    public void ignoreModifications() {
        while (!this.var_queue.isEmpty()) {
            this.var_queue.pollFirst().clearEvents();
        }
    }

    public void dynamicAddition(boolean permanent, Propagator<?> ... ps) throws SolverException {
        int nbp = ps.length;
        for (int i = 0; i < nbp; ++i) {
            if (!permanent) continue;
            ps[i].setPosition(this.propagators.size());
            this.propagators.add(ps[i]);
            this.dynPropagators.add(ps[i]);
        }
    }

    public void updateInvolvedVariables(Propagator<?> p) {
        this.propagateOnBacktrack(p);
    }

    public void propagateOnBacktrack(Propagator<?> propagator) {
        int idx = propagator.getPosition();
        assert (this.propagators.get(idx) == propagator) : "Try to remove the wrong propagator";
        this.shift(idx);
        this.propagators.set(this.propagators.size() - 1, propagator);
        propagator.setPosition(this.propagators.size() - 1);
        this.dynPropagators.addOrUpdate(propagator);
    }

    public void dynamicDeletion(Propagator<?> ... ps) {
        for (Propagator<?> toDelete : ps) {
            if (this.lastProp == toDelete) {
                this.lastProp = null;
            }
            if (toDelete.getPosition() <= -1) continue;
            this.dynPropagators.remove(toDelete);
            this.remove(toDelete);
        }
    }

    private void remove(Propagator<?> propagator) {
        int idx = propagator.getPosition();
        if (idx > -1) {
            assert (this.propagators.get(idx) == propagator) : "Try to remove the wrong propagator";
            this.shift(idx);
            propagator.setPosition(-1);
            this.propagators.remove(this.propagators.size() - 1);
        }
    }

    private void shift(int from) {
        for (int i = from; i < this.propagators.size() - 1; ++i) {
            this.propagators.set(i, this.propagators.get(i + 1));
            this.propagators.get(i).setPosition(i);
        }
    }

    private static class DynPropagators {
        private Propagator<?>[] elements = new Propagator[16];
        private int[] keys = new int[16];
        private int size = 0;

        DynPropagators() {
        }

        public void clear() {
            this.size = 0;
        }

        public void add(Propagator<?> e) {
            this.ensureCapacity();
            this.elements[this.size] = e;
            this.keys[this.size++] = Integer.MAX_VALUE;
        }

        private void ensureCapacity() {
            if (this.size >= this.elements.length - 1) {
                int nsize = ArrayUtils.newBoundedSize(this.elements.length, 8);
                this.elements = Arrays.copyOf(this.elements, nsize);
                this.keys = Arrays.copyOf(this.keys, nsize);
            }
        }

        void addOrUpdate(Propagator<?> e) {
            this.remove(e);
            this.add(e);
        }

        public void remove(Propagator<?> e) {
            int p = this.indexOf(e);
            if (p > -1) {
                this.removeAt(p);
            }
        }

        private void removeAt(int p) {
            if (p < this.size - 1) {
                System.arraycopy(this.elements, p + 1, this.elements, p, this.size - p);
                System.arraycopy(this.keys, p + 1, this.keys, p, this.size - p);
            }
            this.elements[--this.size] = null;
            this.keys[this.size] = 0;
        }

        private int indexOf(Propagator<?> e) {
            for (int i = 0; i < this.size; ++i) {
                if (!e.equals(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        void descending(int w, Consumer<Propagator<?>> cons) {
            for (int i = this.size - 1; i >= 0 && this.keys[i] >= w; --i) {
                cons.accept(this.elements[i]);
                this.keys[i] = w;
            }
        }
    }
}

