/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.coalescent.CoalescentSimulator;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CoalescentTreeRejectionSampler
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "CoalescentTreeRejectionSampler";
    private DefaultTreeModel treeModel;
    private DemographicModel demoModel;
    private TaxonList allTaxa;
    private List<Set> subtree_nodes;
    private final CoalescentSimulator simulator = new CoalescentSimulator();
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(TreeModel.class), new ElementRule(DemographicModel.class), new ElementRule(Tree.class, 0, Integer.MAX_VALUE), new ElementRule(TaxonList.class, 0, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return CoalescentTreeRejectionSampler.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)xMLObject.getChild(TreeModel.class);
            DemographicModel demographicModel = (DemographicModel)xMLObject.getChild(DemographicModel.class);
            ArrayList<TaxonList> arrayList = new ArrayList<TaxonList>();
            ArrayList<Tree> arrayList2 = new ArrayList<Tree>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object = xMLObject.getChild(i);
                if (object instanceof TreeModel) continue;
                if (object instanceof Tree) {
                    arrayList2.add((Tree)object);
                    continue;
                }
                if (!(object instanceof TaxonList)) continue;
                arrayList.add((TaxonList)object);
            }
            ArrayList<Set> arrayList3 = new ArrayList<Set>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList3.add(TreeUtils.getLeafSet((Tree)arrayList2.get(i)));
                System.out.println(arrayList3.get(i));
            }
            return new CoalescentTreeRejectionSampler((TaxonList)arrayList.get(0), arrayList3, defaultTreeModel, demographicModel, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an iterative coalescent sampler - disguised as a Gibbs operator - from a demographic model, to be used in case of monophyletic constraints on a tree.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public CoalescentTreeRejectionSampler(TaxonList taxonList, List<Set> list, DefaultTreeModel defaultTreeModel, DemographicModel demographicModel, double d) {
        this.allTaxa = taxonList;
        this.subtree_nodes = list;
        this.treeModel = defaultTreeModel;
        this.demoModel = demographicModel;
        this.setWeight(d);
    }

    @Override
    public void setPathParameter(double d) {
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    public int getStepCount() {
        return 1;
    }

    @Override
    public double doOperation() {
        Tree tree = this.simulateRecursiveTree();
        this.treeModel.beginTreeEdit();
        this.treeModel.adoptTreeStructure(tree);
        this.treeModel.endTreeEdit();
        return 0.0;
    }

    private Tree simulateRecursiveTree() {
        SimpleTree simpleTree = this.simulator.simulateTree(this.allTaxa, this.demoModel);
        for (int i = 0; i < this.subtree_nodes.size(); ++i) {
            if (TreeUtils.isMonophyletic(simpleTree, this.subtree_nodes.get(i))) continue;
            return this.simulateRecursiveTree();
        }
        return simpleTree;
    }
}

