/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.pack;

import choco.Choco;
import choco.kernel.common.util.comparator.IPermutation;
import choco.kernel.common.util.tools.PermutationUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.set.SetVariable;
import java.util.ArrayList;
import java.util.LinkedList;

public final class PackModel {
    public final IPermutation permutation;
    public final IntegerVariable[] bins;
    public final IntegerConstantVariable[] sizes;
    public final IntegerVariable[] loads;
    public final SetVariable[] items;
    public final IntegerVariable nbNonEmpty;
    public final int maxCapacity;

    public PackModel(int[] sizes, int nbBins, int capacity) {
        this(StringUtils.randomName(), sizes, nbBins, capacity);
    }

    public PackModel(String name, int[] sizes, int nbBins, int capacity) {
        this(name, Choco.constantArray(sizes), nbBins, capacity);
    }

    public PackModel(String prefix, IntegerConstantVariable[] sizes, int nbBins, int capacity) {
        this.bins = Choco.makeIntVarArray(prefix + "B", sizes.length, 0, nbBins - 1, "cp:enum");
        this.loads = Choco.makeIntVarArray(prefix + "L", nbBins, 0, capacity, "cp:bound", "cp:no_decision");
        this.items = Choco.makeSetVarArray(prefix + "S", nbBins, 0, sizes.length - 1, "cp:bound", "cp:no_decision");
        this.nbNonEmpty = Choco.makeIntVar(prefix + "NbNE", 0, nbBins, "cp:bound");
        this.permutation = this.makePermutation(sizes);
        this.sizes = PermutationUtils.applyPermutation(this.permutation, sizes);
        this.maxCapacity = capacity;
    }

    public PackModel(IntegerVariable[] bins, IntegerConstantVariable[] sizes, int capacity) {
        int nbBins = PackModel.computeMax(bins);
        String prefix = StringUtils.randomName() + "-";
        this.loads = Choco.makeIntVarArray(prefix + "L", nbBins, 0, capacity, "cp:bound", "cp:no_decision");
        this.items = Choco.makeSetVarArray(prefix + "S", nbBins, 0, sizes.length - 1, "cp:bound", "cp:no_decision");
        this.nbNonEmpty = Choco.makeIntVar(prefix + "NbNE", 0, nbBins, "cp:bound");
        this.checkArrays(bins, sizes);
        this.permutation = this.makePermutation(sizes);
        this.bins = PermutationUtils.applyPermutation(this.permutation, bins);
        this.sizes = PermutationUtils.applyPermutation(this.permutation, sizes);
        this.maxCapacity = capacity;
    }

    public PackModel(IntegerVariable[] bins, IntegerConstantVariable[] sizes, IntegerVariable[] loads) {
        this.loads = loads;
        String prefix = StringUtils.randomName() + "-";
        this.items = Choco.makeSetVarArray(prefix + "S", loads.length, 0, sizes.length - 1, "cp:bound", "cp:no_decision");
        this.nbNonEmpty = Choco.makeIntVar(prefix + "NbNE", 0, loads.length, "cp:bound");
        this.checkArrays(bins, sizes);
        this.permutation = this.makePermutation(sizes);
        this.bins = PermutationUtils.applyPermutation(this.permutation, bins);
        this.sizes = PermutationUtils.applyPermutation(this.permutation, sizes);
        this.maxCapacity = PackModel.computeMax(loads);
    }

    public PackModel(IntegerVariable[] bins, IntegerConstantVariable[] sizes, SetVariable[] items, IntegerVariable[] loads) {
        this(bins, sizes, items, loads, Choco.makeIntVar(StringUtils.randomName() + "-NbNE", 0, loads.length, "cp:bound"));
    }

    public PackModel(IntegerVariable[] bins, IntegerConstantVariable[] sizes, SetVariable[] items, IntegerVariable[] loads, IntegerVariable nbNonEmpty) {
        this.checkArrays(bins, sizes);
        this.checkArrays(loads, items);
        for (int i = 1; i < sizes.length; ++i) {
            if (sizes[i].getValue() <= sizes[i - 1].getValue()) continue;
            throw new ModelException("sizes must be sorted according to non increasing order.");
        }
        this.permutation = PermutationUtils.getIdentity();
        this.bins = bins;
        this.sizes = sizes;
        this.loads = loads;
        this.items = items;
        this.nbNonEmpty = nbNonEmpty;
        this.maxCapacity = PackModel.computeMax(loads);
    }

    private IPermutation makePermutation(IntegerConstantVariable[] sizes) {
        return PermutationUtils.replaceByIdentity(PermutationUtils.getSortingPermuation(sizes, true));
    }

    private static int computeMax(IntegerVariable[] vars) {
        int maxCapa = Integer.MIN_VALUE;
        for (IntegerVariable v : vars) {
            int lm = v.getUppB();
            if (lm <= maxCapa) continue;
            maxCapa = lm;
        }
        return maxCapa;
    }

    private void checkArrays(Object[] o1, Object[] o2) {
        if (o1.length != o2.length) {
            throw new ModelException("Invalid Arrays sizes.");
        }
    }

    public final Variable[] getVariables() {
        int n = this.getNbItems();
        int m = this.getNbBins();
        for (int i = 1; i < n; ++i) {
            if (this.sizes[i].getValue() <= this.sizes[i - 1].getValue()) continue;
            throw new ModelException("sizes must be sorted according to non increasing order.");
        }
        Variable[] vars = new Variable[2 * (n + m) + 1];
        System.arraycopy(this.items, 0, vars, 0, m);
        System.arraycopy(this.loads, 0, vars, m, m);
        System.arraycopy(this.bins, 0, vars, 2 * m, n);
        System.arraycopy(this.sizes, 0, vars, 2 * m + n, n);
        vars[vars.length - 1] = this.nbNonEmpty;
        return vars;
    }

    public final int getNbBins() {
        return this.loads.length;
    }

    public final int getNbItems() {
        return this.bins.length;
    }

    public final IntegerVariable[] getBins() {
        return this.bins;
    }

    public final IntegerConstantVariable[] getSizes() {
        return this.sizes;
    }

    public final SetVariable[] getItems() {
        return this.items;
    }

    public final IntegerVariable[] getLoads() {
        return this.loads;
    }

    public final int getMaxCapacity() {
        return this.maxCapacity;
    }

    @Deprecated
    public Constraint[] orderEqualSizedItems(int fromIndex) {
        ArrayList<Constraint> cstr = new ArrayList<Constraint>();
        int n = this.getNbItems() - 1;
        for (int i = fromIndex; i < n; ++i) {
            if (this.sizes[i].getValue() != this.sizes[i + 1].getValue()) continue;
            cstr.add(Choco.leq((IntegerExpressionVariable)this.bins[i], (IntegerExpressionVariable)this.bins[i + 1]));
        }
        return cstr.toArray(new Constraint[cstr.size()]);
    }

    public int orderEqualSizedItems(Model model, int fromIndex) {
        int n = this.getNbItems() - 1;
        int nbC = 0;
        for (int i = fromIndex; i < n; ++i) {
            if (this.sizes[i].getValue() != this.sizes[i + 1].getValue()) continue;
            model.addConstraint(Choco.leq((IntegerExpressionVariable)this.bins[i], (IntegerExpressionVariable)this.bins[i + 1]));
            ++nbC;
        }
        return nbC;
    }

    private boolean isLargeItem(int idx) {
        return idx < this.bins.length && this.sizes[idx].getValue() > this.maxCapacity / 2;
    }

    private boolean isAdditionalLargeItem(int idx) {
        return idx == 0 || idx < this.bins.length && this.sizes[idx].getValue() + this.sizes[idx - 1].getValue() > this.maxCapacity;
    }

    @Deprecated
    public final Constraint[] packLargeItems() {
        ArrayList<Constraint> cstr = new ArrayList<Constraint>();
        int nbP = 0;
        while (this.isLargeItem(nbP)) {
            cstr.add(Choco.eq((IntegerExpressionVariable)this.bins[nbP], nbP));
            ++nbP;
        }
        if (this.isAdditionalLargeItem(nbP)) {
            cstr.add(Choco.eq((IntegerExpressionVariable)this.bins[nbP], nbP));
        }
        return cstr.isEmpty() ? null : cstr.toArray(new Constraint[cstr.size()]);
    }

    public final int packLargeItems(Model m) {
        int nbP = 0;
        while (this.isLargeItem(nbP)) {
            m.addConstraint(Choco.eq((IntegerExpressionVariable)this.bins[nbP], nbP));
            ++nbP;
        }
        if (this.isAdditionalLargeItem(nbP)) {
            m.addConstraint(Choco.eq((IntegerExpressionVariable)this.bins[nbP], nbP));
        }
        return nbP;
    }

    public final Constraint allDiffLargeItems() {
        LinkedList<IntegerVariable> vars = new LinkedList<IntegerVariable>();
        int nbP = 0;
        while (this.isLargeItem(nbP)) {
            vars.add(this.bins[nbP++]);
        }
        if (this.isAdditionalLargeItem(nbP)) {
            vars.add(this.bins[nbP++]);
        }
        return vars.isEmpty() ? Choco.TRUE : Choco.allDifferent(vars.toArray(new IntegerVariable[nbP]));
    }

    @Deprecated
    public final Constraint[] decreasingLoads(int fromIndex) {
        return PackModel.symBreakDecreasingOrder(this.loads, fromIndex);
    }

    public final int decreasingLoads(Model model, int fromIndex) {
        return PackModel.symBreakDecreasingOrder(model, this.loads, fromIndex);
    }

    @Deprecated
    public final Constraint[] decreasingCardinalities(int fromIndex) {
        return PackModel.symBreakDecreasingOrder(VariableUtils.getCardinalities(this.items), fromIndex);
    }

    public final int decreasingCardinalities(Model model, int fromIndex) {
        return PackModel.symBreakDecreasingOrder(model, VariableUtils.getCardinalities(this.items), fromIndex);
    }

    private static final Constraint[] symBreakDecreasingOrder(IntegerVariable[] vars, int fromIndex) {
        int nb = vars.length - fromIndex - 1;
        if (nb > 0) {
            Constraint[] cstr = new Constraint[nb];
            int n = vars.length - 1;
            for (int i = fromIndex; i < n; ++i) {
                cstr[i - fromIndex] = Choco.geq((IntegerExpressionVariable)vars[i], (IntegerExpressionVariable)vars[i + 1]);
            }
            return cstr;
        }
        return null;
    }

    private static final int symBreakDecreasingOrder(Model model, IntegerVariable[] vars, int fromIndex) {
        int n = vars.length - 1;
        for (int i = fromIndex; i < n; ++i) {
            model.addConstraint(Choco.geq((IntegerExpressionVariable)vars[i], (IntegerExpressionVariable)vars[i + 1]));
        }
        return vars.length - fromIndex;
    }
}

