/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;

public class TreeBitMoveOperator
extends SimpleMCMCOperator {
    private TreeModel tree;
    private String indicatorTrait;
    private String trait2;

    public TreeBitMoveOperator(TreeModel treeModel, String string, String string2, double d) {
        this.tree = treeModel;
        this.indicatorTrait = string;
        this.trait2 = string2;
        if (this.indicatorTrait == null) {
            this.indicatorTrait = "trait";
        }
        this.setWeight(d);
    }

    @Override
    public final double doOperation() {
        NodeRef nodeRef;
        NodeRef nodeRef2 = this.tree.getRoot();
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            nodeRef = this.tree.getNode(i);
            if (nodeRef == nodeRef2 || this.tree.getParent(nodeRef) == nodeRef2) continue;
            NodeRef nodeRef3 = this.tree.getParent(nodeRef);
            int n = this.rateChange(this.tree, nodeRef) + this.rateChange(this.tree, nodeRef3);
            if (n != 1) continue;
            arrayList.add(nodeRef);
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No suitable pairs!");
        }
        NodeRef nodeRef4 = (NodeRef)arrayList.get(MathUtils.nextInt(arrayList.size()));
        nodeRef = this.tree.getParent(nodeRef4);
        double d = this.tree.getNodeTrait(nodeRef4, this.indicatorTrait);
        double d2 = this.tree.getNodeTrait(nodeRef, this.indicatorTrait);
        this.tree.setNodeTrait(nodeRef4, this.indicatorTrait, d2);
        this.tree.setNodeTrait(nodeRef, this.indicatorTrait, d);
        if (this.trait2 != null) {
            d = this.tree.getNodeTrait(nodeRef4, this.trait2);
            d2 = this.tree.getNodeTrait(nodeRef, this.trait2);
            this.tree.setNodeTrait(nodeRef4, this.trait2, d2);
            this.tree.setNodeTrait(nodeRef, this.trait2, d);
        } else {
            double d3 = this.tree.getNodeRate(nodeRef4);
            double d4 = this.tree.getNodeRate(nodeRef);
            this.tree.setNodeRate(nodeRef4, d4);
            this.tree.setNodeRate(nodeRef, d3);
        }
        return 0.0;
    }

    public final int rateChange(TreeModel treeModel, NodeRef nodeRef) {
        return (int)Math.round(treeModel.getNodeTrait(nodeRef, this.indicatorTrait));
    }

    @Override
    public final String getOperatorName() {
        return "treeBitMove()";
    }

    public final String getPerformanceSuggestion() {
        return "no performance suggestion";
    }

    public String toString() {
        return this.getOperatorName();
    }
}

