/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.speciation.CalibrationPoints;
import dr.evomodel.speciation.SpeciationModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.Set;

public class SpeciationLikelihood
extends AbstractModelLikelihood
implements Units {
    SpeciationModel speciationModel = null;
    Tree tree = null;
    private final Set<Taxon> exclude;
    private CalibrationPoints calibration;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;

    public SpeciationLikelihood(Tree tree, SpeciationModel speciationModel, Set<Taxon> set, String string) {
        this("speciationLikelihood", tree, speciationModel, set);
        this.setId(string);
    }

    public SpeciationLikelihood(Tree tree, SpeciationModel speciationModel, String string) {
        this(tree, speciationModel, null, string);
    }

    public SpeciationLikelihood(String string, Tree tree, SpeciationModel speciationModel, Set<Taxon> set) {
        super(string);
        this.tree = tree;
        this.speciationModel = speciationModel;
        this.exclude = set;
        if (tree instanceof Model) {
            this.addModel((Model)((Object)tree));
        }
        if (speciationModel != null) {
            this.addModel(speciationModel);
        }
    }

    public SpeciationLikelihood(Tree tree, SpeciationModel speciationModel, String string, CalibrationPoints calibrationPoints) {
        this(tree, speciationModel, string);
        this.calibration = calibrationPoints;
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected final void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected final void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
    }

    private double calculateLogLikelihood() {
        if (this.exclude != null) {
            return this.speciationModel.calculateTreeLogLikelihood(this.tree, this.exclude);
        }
        if (this.calibration != null) {
            return this.speciationModel.calculateTreeLogLikelihood(this.tree, this.calibration);
        }
        return this.speciationModel.calculateTreeLogLikelihood(this.tree);
    }

    @Override
    public final LogColumn[] getColumns() {
        String string = this.getId();
        if (string == null) {
            string = this.getModelName() + ".likelihood";
        }
        return new LogColumn[]{new LikelihoodColumn(string)};
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.speciationModel.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.speciationModel.getUnits();
    }

    @Override
    public String prettyName() {
        String string = this.speciationModel.getClass().getName();
        String[] stringArray = string.split("\\.");
        string = stringArray[stringArray.length - 1];
        if (this.speciationModel.getId() != null) {
            string = string + '/' + this.speciationModel.getId();
        }
        string = string + '(' + this.tree.getId() + ')';
        return string;
    }

    private final class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return SpeciationLikelihood.this.getLogLikelihood();
        }
    }
}

