/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceCorrelation;
import dr.inference.trace.TraceException;
import dr.util.TabularData;
import java.io.File;
import java.io.IOException;

public class LogFileTraceExporter
extends TabularData {
    private final LogFileTraces analysis;
    private final String[] rows = new String[]{"mean", "median", "hpdLower", "hpdUpper", "ESS"};
    TraceCorrelation[] distributions;

    public LogFileTraceExporter(File file, int n) throws TraceException, IOException {
        this.analysis = new LogFileTraces(file.getCanonicalPath(), file);
        this.analysis.loadTraces();
        if (n >= 0) {
            this.analysis.setBurnIn(n);
        }
        this.distributions = new TraceCorrelation[this.nColumns()];
    }

    @Override
    public int nColumns() {
        return this.analysis.getTraceCount();
    }

    @Override
    public String columnName(int n) {
        return this.analysis.getTraceName(n);
    }

    @Override
    public int nRows() {
        return this.rows.length;
    }

    @Override
    public Object data(int n, int n2) {
        if (this.distributions[n2] == null) {
            this.analysis.analyseTrace(n2);
            this.distributions[n2] = this.analysis.getCorrelationStatistics(n2);
        }
        TraceCorrelation traceCorrelation = this.distributions[n2];
        switch (n) {
            case 0: {
                return traceCorrelation.getMean();
            }
            case 1: {
                return traceCorrelation.getMedian();
            }
            case 2: {
                return traceCorrelation.getLowerHPD();
            }
            case 3: {
                return traceCorrelation.getUpperHPD();
            }
            case 4: {
                return traceCorrelation.getESS();
            }
        }
        return null;
    }
}

