/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.MatrixCalcException;

public final class MatrixCalc {
    public static double[][] choleskyFactor(double[][] inMatrix) throws MatrixCalcException.NotSquareMatrixException, MatrixCalcException.PositiveDefiniteException {
        if (inMatrix.length != inMatrix[0].length) {
            throw new MatrixCalcException.NotSquareMatrixException("error in CholeskyFactor, not a square matrix");
        }
        double[][] inMatrix_ent = inMatrix;
        for (int k = 0; k < inMatrix.length; ++k) {
            int j;
            double sum = inMatrix_ent[k][k];
            double[] inMatrix_piv = inMatrix_ent[k];
            for (j = 0; j < k; ++j) {
                double tmp = inMatrix_ent[k][j];
                sum -= tmp * tmp;
            }
            if (sum <= 0.0) {
                throw new MatrixCalcException.PositiveDefiniteException("error in CholeskyFactor, sum");
            }
            inMatrix_ent[k][k] = Math.sqrt(sum);
            for (int i = k + 1; i < inMatrix.length; ++i) {
                sum = inMatrix_ent[i][k];
                inMatrix_piv = inMatrix_ent[k];
                double[] inMatrix_row = inMatrix_ent[i];
                for (j = 0; j < k; ++j) {
                    sum -= inMatrix_ent[i][j] * inMatrix_ent[k][j];
                    sum -= inMatrix_row[j] * inMatrix_piv[j];
                }
                double d = sum / inMatrix_ent[k][k];
                inMatrix_ent[i][j] = d;
                inMatrix_ent[j][i] = d;
            }
        }
        return inMatrix;
    }

    public static double[] choleskySolve(double[][] matrix, double[] vector) throws MatrixCalcException.NotSquareMatrixException {
        if (matrix.length != matrix[0].length || matrix[0].length != vector.length) {
            throw new MatrixCalcException.NotSquareMatrixException("error in CholeskySolve, not a square matrix");
        }
        double[] retVector = new double[vector.length];
        retVector = MatrixCalc.lowerSolve(matrix, vector, 0.0);
        retVector = MatrixCalc.upperSolve(matrix, retVector, 0.0);
        return retVector;
    }

    public static double[] lowerSolve(double[][] matrix, double[] vector, double diag) {
        int i;
        double[] out = new double[vector.length];
        int dimension = matrix.length < matrix[0].length ? matrix.length : matrix[0].length;
        if (vector.length < dimension) {
            System.out.println("error in LSolve, problem with vector length");
            System.exit(0);
        }
        if (out.length < dimension) {
            out = new double[matrix.length];
        }
        double[][] mat_ent = matrix;
        double[] vector_ent = vector;
        double[] out_ent = out;
        for (i = 0; i < dimension && vector_ent[i] == 0.0; ++i) {
            out_ent[i] = 0.0;
        }
        int i_lim = i;
        while (i < dimension) {
            double sum = vector_ent[i];
            for (int j = i_lim; j < i; ++j) {
                sum -= mat_ent[i][j] * out_ent[j];
            }
            if (diag == 0.0) {
                if (mat_ent[i][i] == 0.0) {
                    System.out.println("error in LSolve, error in matrix");
                    System.exit(0);
                } else {
                    out_ent[i] = sum / mat_ent[i][i];
                }
            } else {
                out_ent[i] = sum / diag;
            }
            ++i;
        }
        return out;
    }

    public static double[] upperSolve(double[][] matrix, double[] vector, double diag) {
        int i;
        int ilim = 0;
        double[] out = new double[matrix.length];
        int dimension = matrix.length < matrix[0].length ? matrix.length : matrix[0].length;
        if (vector.length < dimension) {
            System.out.println("error in upperSolve");
            System.exit(1);
        }
        if (out == null || out.length < dimension) {
            out = new double[matrix.length];
        }
        if (out.length < dimension) {
            out = new double[matrix.length];
        }
        double[][] matrix_ent = matrix;
        double[] vector_ent = vector;
        double[] out_ent = out;
        for (i = dimension - 1; i >= 0 && vector_ent[i] == 0.0; --i) {
            out_ent[i] = 0.0;
        }
        ilim = i;
        while (i >= 0) {
            double sum = vector_ent[i];
            for (int j = i + 1; j <= ilim; ++j) {
                sum -= matrix_ent[i][j] * out_ent[j];
            }
            if (diag == 0.0) {
                if (matrix_ent[i][i] == 0.0) {
                    System.out.println("error in USolve");
                    System.exit(1);
                } else {
                    out_ent[i] = sum / matrix_ent[i][i];
                }
            } else {
                out_ent[i] = sum / diag;
            }
            --i;
        }
        return out;
    }

    public static double innerProduct(double[] vector1, double[] vector2, int x) throws IndexOutOfBoundsException {
        double sum = 0.0;
        int length = vector1.length < vector2.length ? vector1.length : vector2.length;
        if (x > length) {
            throw new IndexOutOfBoundsException("innerProduct int x out of vector bounds");
        }
        for (int i = x; i < length; ++i) {
            sum += vector1[i] * vector2[i];
        }
        return sum;
    }

    public static double[] getColumn(double[][] matrix, int column) {
        double[] x = new double[matrix.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = matrix[i][column];
        }
        return x;
    }

    public static double[][] deleteMatrixRow(double[][] matrix, int row) {
        double[][] x = new double[matrix.length - 1][matrix[0].length];
        int j = 0;
        for (int i = 0; i < matrix.length; ++i) {
            if (i == row) continue;
            System.arraycopy(matrix[i], 0, x[j], 0, matrix[i].length);
            ++j;
        }
        return x;
    }

    public static double[][] deleteMatrixColumn(double[][] matrix, int column) {
        double[][] x = new double[matrix.length][matrix[0].length - 1];
        for (int i = 0; i < matrix.length; ++i) {
            int j = 0;
            for (int k = 0; k < matrix[i].length; ++k) {
                if (k == column) continue;
                x[i][j] = matrix[i][k];
                ++j;
            }
        }
        return x;
    }

    public static double[] reverseVector(double[] vector) {
        double[] x = new double[vector.length];
        int j = 0;
        for (int i = vector.length - 1; i >= 0; --i) {
            x[i] = vector[j];
            ++j;
        }
        return x;
    }

    public static double[][] reverseMatrix(double[][] matrix) {
        double[][] x = new double[matrix.length][matrix[0].length];
        int j = 0;
        for (int i = matrix.length - 1; i >= 0; --i) {
            int k = 0;
            for (int h = matrix[0].length - 1; h >= 0; --h) {
                x[j][k] = matrix[i][h];
                ++k;
            }
            ++j;
        }
        return x;
    }

    public static double sumVector(double[] vector) {
        double sum = 0.0;
        for (double aVector : vector) {
            sum += aVector;
        }
        return sum;
    }

    public static double[][] copyMatrix(double[][] matrix) {
        double[][] x = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[i].length; ++j) {
                x[i][j] = matrix[i][j];
            }
        }
        return x;
    }
}

