/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu.twosample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.twosample.TwoSampleModel;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class SplitDialog
extends JDialog
implements ActionListener,
FocusListener {
    private JRadioButton cut;
    private JRadioButton define;
    private JList group1List;
    private ButtonGroup buttonGroup;
    private JPanel okayCancel;
    private JList group2List;
    private JList levelsList;
    private JButton remove1;
    private JScrollPane grp2Scroller;
    private JScrollPane grp1Scroller;
    private JScrollPane levelsScroller;
    private JButton remove2;
    private JButton add2;
    private JButton add1;
    private JPanel group2Panel;
    private JPanel group1Panel;
    private JPanel Levels;
    private JTextField cutValue;
    private TwoSampleModel.SplitModel model;
    private String data;
    private String factor;

    public SplitDialog(JDialog jDialog, TwoSampleModel.SplitModel splitModel, String string, String string2) {
        super(jDialog);
        this.model = splitModel;
        this.data = string;
        this.factor = string2;
        this.initGUI();
        this.reset();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.cut = new JRadioButton();
            this.getContentPane().add(this.cut);
            this.cut.setText("Cut at");
            this.cut.setBounds(30, 12, 77, 19);
            this.cutValue = new JTextField();
            this.getContentPane().add(this.cutValue);
            this.cutValue.setBounds(107, 10, 86, 22);
            this.cutValue.addFocusListener(this);
            this.define = new JRadioButton();
            this.getContentPane().add(this.define);
            this.define.setText("Define Groups");
            this.define.setBounds(30, 38, 135, 19);
            this.Levels = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.Levels.setLayout(borderLayout);
            this.getContentPane().add(this.Levels);
            this.Levels.setBounds(45, 57, 153, 169);
            this.Levels.setBorder(BorderFactory.createTitledBorder("Levels"));
            this.levelsScroller = new JScrollPane();
            this.Levels.add((Component)this.levelsScroller, "Center");
            this.levelsScroller.setPreferredSize(new Dimension(150, 144));
            DefaultListModel defaultListModel = new DefaultListModel();
            this.levelsList = new JList();
            this.levelsScroller.setViewportView(this.levelsList);
            this.levelsList.setModel(defaultListModel);
            this.levelsList.addFocusListener(this);
            this.group1Panel = new JPanel();
            borderLayout = new BorderLayout();
            this.group1Panel.setLayout(borderLayout);
            this.getContentPane().add(this.group1Panel);
            this.group1Panel.setBounds(247, 54, 150, 80);
            this.group1Panel.setBorder(BorderFactory.createTitledBorder("Group 1"));
            this.grp1Scroller = new JScrollPane();
            this.group1Panel.add((Component)this.grp1Scroller, "Center");
            this.group1List = new JList();
            this.group1List.setModel(new DefaultListModel());
            this.grp1Scroller.setViewportView(this.group1List);
            this.group1List.addFocusListener(this);
            this.group2Panel = new JPanel();
            borderLayout = new BorderLayout();
            this.group2Panel.setLayout(borderLayout);
            this.getContentPane().add(this.group2Panel);
            this.group2Panel.setBounds(246, 146, 150, 80);
            this.group2Panel.setBorder(BorderFactory.createTitledBorder("Group 2"));
            this.grp2Scroller = new JScrollPane();
            this.group2Panel.add((Component)this.grp2Scroller, "Center");
            this.group2List = new JList();
            this.group2List.setModel(new DefaultListModel());
            this.grp2Scroller.setViewportView(this.group2List);
            this.group2List.addFocusListener(this);
            this.add1 = new IconButton("/icons/1rightarrow_32.png", "Add to Group 1", this, "Add to Group 1");
            this.getContentPane().add(this.add1);
            this.add1.setBounds(210, 68, 32, 32);
            this.add1.addFocusListener(this);
            this.remove1 = new IconButton("/icons/1leftarrow_32.png", "Remove from Group 1", this, "Remove from Group 1");
            this.getContentPane().add(this.remove1);
            this.remove1.setBounds(210, 99, 32, 32);
            this.remove1.addFocusListener(this);
            this.add2 = new IconButton("/icons/1rightarrow_32.png", "Add to Group 2", this, "Add to Group 2");
            this.getContentPane().add(this.add2);
            this.add2.setBounds(210, 158, 32, 32);
            this.add2.addFocusListener(this);
            this.remove2 = new IconButton("/icons/1leftarrow_32.png", "Remove from Group 2", this, "Remove from Group 2");
            this.getContentPane().add(this.remove2);
            this.remove2.setBounds(210, 189, 32, 32);
            this.remove2.addFocusListener(this);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(171, 232, 225, 45);
            this.getButtonGroup();
            this.define.setSelected(true);
            this.setTitle("Define Groups");
            this.setResizable(false);
            this.setSize(409, 295);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.cut);
            this.buttonGroup.add(this.define);
        }
        return this.buttonGroup;
    }

    public void reset() {
        if (this.data != null && this.factor != null) {
            String[] stringArray = null;
            try {
                stringArray = Deducer.timedEval("levels(as.factor(" + this.data + "[[\"" + this.factor + "\"]]))").asStrings();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
            if (stringArray != null && stringArray.length < 50) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ((DefaultListModel)this.levelsList.getModel()).addElement(stringArray[i]);
                }
            } else {
                this.model.group1 = new Vector();
                this.model.group2 = new Vector();
                this.define.setEnabled(false);
                this.group1List.setEnabled(false);
                this.group2List.setEnabled(false);
                this.levelsList.setEnabled(false);
                this.add1.setEnabled(false);
                this.remove1.setEnabled(false);
                this.add2.setEnabled(false);
                this.remove2.setEnabled(false);
            }
        }
        if (this.model.isCut) {
            this.cut.setSelected(true);
            this.cutValue.setText(this.model.cutPoint);
        } else {
            int n;
            this.define.setSelected(true);
            ((DefaultListModel)this.group1List.getModel()).removeAllElements();
            for (n = 0; n < this.model.group1.size(); ++n) {
                if (!((DefaultListModel)this.levelsList.getModel()).contains(this.model.group1.get(n))) continue;
                ((DefaultListModel)this.group1List.getModel()).addElement(this.model.group1.get(n));
                ((DefaultListModel)this.levelsList.getModel()).removeElement(this.model.group1.get(n));
            }
            ((DefaultListModel)this.group2List.getModel()).removeAllElements();
            for (n = 0; n < this.model.group2.size(); ++n) {
                if (!((DefaultListModel)this.levelsList.getModel()).contains(this.model.group2.get(n))) continue;
                ((DefaultListModel)this.group2List.getModel()).addElement(this.model.group2.get(n));
                ((DefaultListModel)this.levelsList.getModel()).removeElement(this.model.group2.get(n));
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Add to Group 1") {
            Object[] objectArray = this.levelsList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.levelsList.getModel()).removeElement(objectArray[i]);
                ((DefaultListModel)this.group1List.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Add to Group 2") {
            Object[] objectArray = this.levelsList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.levelsList.getModel()).removeElement(objectArray[i]);
                ((DefaultListModel)this.group2List.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove from Group 1") {
            Object[] objectArray = this.group1List.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.group1List.getModel()).removeElement(objectArray[i]);
                ((DefaultListModel)this.levelsList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove from Group 2") {
            Object[] objectArray = this.group2List.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.group2List.getModel()).removeElement(objectArray[i]);
                ((DefaultListModel)this.levelsList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "OK") {
            if (this.cut.isSelected()) {
                this.model.isCut = true;
                this.model.cutPoint = this.cutValue.getText();
            } else {
                int n;
                this.model.isCut = false;
                Vector vector = new Vector();
                DefaultListModel defaultListModel = (DefaultListModel)this.group1List.getModel();
                for (n = 0; n < defaultListModel.getSize(); ++n) {
                    vector.add(defaultListModel.get(n));
                }
                this.model.group1 = vector;
                vector = new Vector();
                defaultListModel = (DefaultListModel)this.group2List.getModel();
                for (n = 0; n < defaultListModel.getSize(); ++n) {
                    vector.add(defaultListModel.get(n));
                }
                this.model.group2 = vector;
            }
            this.dispose();
        } else if (string == "Cancel") {
            this.dispose();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.cutValue) {
            this.cut.setSelected(true);
        } else {
            this.define.setSelected(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

