/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.differential.IntegratedByteIntegerCODEC;
import me.lemire.integercompression.differential.IntegratedIntegerCODEC;
import me.lemire.integercompression.differential.SkippableIntegratedIntegerCODEC;

public class IntegratedVariableByte
implements IntegratedIntegerCODEC,
IntegratedByteIntegerCODEC,
SkippableIntegratedIntegerCODEC {
    private static byte extract7bits(int i, long val) {
        return (byte)(val >> 7 * i & 0x7FL);
    }

    private static byte extract7bitsmaskless(int i, long val) {
        return (byte)(val >> 7 * i);
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int initoffset = 0;
        ByteBuffer buf = ByteBuffer.allocateDirect(inlength * 8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)(in[k] - initoffset) & 0xFFFFFFFFL;
            initoffset = in[k];
            if (val < 128L) {
                buf.put((byte)(val | 0x80L));
                continue;
            }
            if (val < 16384L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(1, val) | 0x80));
                continue;
            }
            if (val < 0x200000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(2, val) | 0x80));
                continue;
            }
            if (val < 0x10000000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put(IntegratedVariableByte.extract7bits(2, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(3, val) | 0x80));
                continue;
            }
            buf.put(IntegratedVariableByte.extract7bits(0, val));
            buf.put(IntegratedVariableByte.extract7bits(1, val));
            buf.put(IntegratedVariableByte.extract7bits(2, val));
            buf.put(IntegratedVariableByte.extract7bits(3, val));
            buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(4, val) | 0x80));
        }
        while (buf.position() % 4 != 0) {
            buf.put((byte)0);
        }
        int length = buf.position();
        buf.flip();
        IntBuffer ibuf = buf.asIntBuffer();
        ibuf.get(out, outpos.get(), length / 4);
        outpos.add(length / 4);
        inpos.add(inlength);
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, byte[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int initoffset = 0;
        int outpostmp = outpos.get();
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)(in[k] - initoffset) & 0xFFFFFFFFL;
            initoffset = in[k];
            if (val < 128L) {
                out[outpostmp++] = (byte)(val | 0x80L);
                continue;
            }
            if (val < 16384L) {
                out[outpostmp++] = IntegratedVariableByte.extract7bits(0, val);
                out[outpostmp++] = (byte)(IntegratedVariableByte.extract7bitsmaskless(1, val) | 0x80);
                continue;
            }
            if (val < 0x200000L) {
                out[outpostmp++] = IntegratedVariableByte.extract7bits(0, val);
                out[outpostmp++] = IntegratedVariableByte.extract7bits(1, val);
                out[outpostmp++] = (byte)(IntegratedVariableByte.extract7bitsmaskless(2, val) | 0x80);
                continue;
            }
            if (val < 0x10000000L) {
                out[outpostmp++] = IntegratedVariableByte.extract7bits(0, val);
                out[outpostmp++] = IntegratedVariableByte.extract7bits(1, val);
                out[outpostmp++] = IntegratedVariableByte.extract7bits(2, val);
                out[outpostmp++] = (byte)(IntegratedVariableByte.extract7bitsmaskless(3, val) | 0x80);
                continue;
            }
            out[outpostmp++] = IntegratedVariableByte.extract7bits(0, val);
            out[outpostmp++] = IntegratedVariableByte.extract7bits(1, val);
            out[outpostmp++] = IntegratedVariableByte.extract7bits(2, val);
            out[outpostmp++] = IntegratedVariableByte.extract7bits(3, val);
            out[outpostmp++] = (byte)(IntegratedVariableByte.extract7bitsmaskless(4, val) | 0x80);
        }
        outpos.set(outpostmp);
        inpos.add(inlength);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int s = 0;
        int val = 0;
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int initoffset = 0;
        int v = 0;
        int shift = 0;
        while (p < finalp) {
            val = in[p];
            byte c = (byte)(val >>> s);
            p += (s += 8) >> 5;
            s &= 0x1F;
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 128) {
                out[tmpoutpos] = v + initoffset;
                initoffset = out[tmpoutpos];
                ++tmpoutpos;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        outpos.set(tmpoutpos);
        inpos.add(inlength);
    }

    public void uncompress(byte[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int p = inpos.get();
        int initoffset = 0;
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int v = 0;
        while (p < finalp) {
            v = in[p] & 0x7F;
            if (in[p] < 0) {
                ++p;
            } else {
                v = (in[p + 1] & 0x7F) << 7 | v;
                if (in[p + 1] < 0) {
                    p += 2;
                } else {
                    v = (in[p + 2] & 0x7F) << 14 | v;
                    if ((in[p + 2] & 0x80) == 128) {
                        p += 3;
                    } else {
                        v = (in[p + 3] & 0x7F) << 21 | v;
                        if ((in[p + 3] & 0x80) == 128) {
                            p += 4;
                        } else {
                            v = (in[p + 4] & 0x7F) << 28 | v;
                            p += 5;
                        }
                    }
                }
            }
            out[tmpoutpos++] = initoffset += v;
        }
        outpos.set(tmpoutpos);
        inpos.add(p);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, IntWrapper initvalue) {
        if (inlength == 0) {
            return;
        }
        int initoffset = initvalue.get();
        initvalue.set(in[inpos.get() + inlength - 1]);
        ByteBuffer buf = ByteBuffer.allocateDirect(inlength * 8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)(in[k] - initoffset) & 0xFFFFFFFFL;
            initoffset = in[k];
            if (val < 128L) {
                buf.put((byte)(val | 0x80L));
                continue;
            }
            if (val < 16384L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(1, val) | 0x80));
                continue;
            }
            if (val < 0x200000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(2, val) | 0x80));
                continue;
            }
            if (val < 0x10000000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put(IntegratedVariableByte.extract7bits(2, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(3, val) | 0x80));
                continue;
            }
            buf.put(IntegratedVariableByte.extract7bits(0, val));
            buf.put(IntegratedVariableByte.extract7bits(1, val));
            buf.put(IntegratedVariableByte.extract7bits(2, val));
            buf.put(IntegratedVariableByte.extract7bits(3, val));
            buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(4, val) | 0x80));
        }
        while (buf.position() % 4 != 0) {
            buf.put((byte)0);
        }
        int length = buf.position();
        buf.flip();
        IntBuffer ibuf = buf.asIntBuffer();
        ibuf.get(out, outpos.get(), length / 4);
        outpos.add(length / 4);
        inpos.add(inlength);
    }

    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int num, IntWrapper initvalue) {
        int s = 0;
        int val = 0;
        int p = inpos.get();
        int initoffset = initvalue.get();
        int tmpoutpos = outpos.get();
        int finaloutpos = num + tmpoutpos;
        int v = 0;
        int shift = 0;
        while (tmpoutpos < finaloutpos) {
            val = in[p];
            byte c = (byte)(val >>> s);
            p += (s += 8) >> 5;
            s &= 0x1F;
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 128) {
                out[tmpoutpos++] = initoffset += v;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        initvalue.set(out[tmpoutpos - 1]);
        outpos.set(tmpoutpos);
        inpos.set(p + (s != 0 ? 1 : 0));
    }
}

