/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openfast.ApplicationTypeDictionary;
import org.openfast.Dictionary;
import org.openfast.GlobalDictionary;
import org.openfast.NullOpenFastContext;
import org.openfast.OpenFastContext;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.TemplateDictionary;
import org.openfast.debug.BasicDecodeTrace;
import org.openfast.debug.BasicEncodeTrace;
import org.openfast.debug.Trace;
import org.openfast.error.ErrorHandler;
import org.openfast.error.FastConstants;
import org.openfast.logging.FastMessageLogger;
import org.openfast.template.BasicTemplateRegistry;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegisteredListener;
import org.openfast.template.TemplateRegistry;
import org.openfast.util.Cache;
import org.openfast.util.UnboundedCache;

public class Context
implements OpenFastContext {
    private TemplateRegistry templateRegistry = new BasicTemplateRegistry();
    private int lastTemplateId;
    private final Map dictionaries = new HashMap();
    private ErrorHandler errorHandler = ErrorHandler.DEFAULT;
    private QName currentApplicationType;
    private final List listeners = Collections.EMPTY_LIST;
    private boolean traceEnabled;
    private Trace encodeTrace;
    private Trace decodeTrace;
    private final Map caches = new HashMap();
    private final OpenFastContext parentContext;
    private FastMessageLogger logger = null;

    public Context() {
        this(new NullOpenFastContext());
    }

    public Context(OpenFastContext context) {
        this.parentContext = context;
        this.dictionaries.put("global", new GlobalDictionary());
        this.dictionaries.put("template", new TemplateDictionary());
        this.dictionaries.put("type", new ApplicationTypeDictionary());
    }

    public int getTemplateId(MessageTemplate template) {
        if (!this.templateRegistry.isRegistered(template)) {
            this.errorHandler.error(FastConstants.D9_TEMPLATE_NOT_REGISTERED, "The template " + template + " has not been registered.");
            return 0;
        }
        return this.templateRegistry.getId(template);
    }

    public MessageTemplate getTemplate(int templateId) {
        if (!this.templateRegistry.isRegistered(templateId)) {
            this.errorHandler.error(FastConstants.D9_TEMPLATE_NOT_REGISTERED, "The template with id " + templateId + " has not been registered.");
            return null;
        }
        return this.templateRegistry.get(templateId);
    }

    public void registerTemplate(int templateId, MessageTemplate template) {
        this.templateRegistry.register(templateId, template);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((TemplateRegisteredListener)iter.next()).templateRegistered(template, templateId);
        }
    }

    public int getLastTemplateId() {
        return this.lastTemplateId;
    }

    public void setLastTemplateId(int templateId) {
        this.lastTemplateId = templateId;
    }

    public ScalarValue lookup(String dictionary, Group group, QName key) {
        if (group.hasTypeReference()) {
            this.currentApplicationType = group.getTypeReference();
        }
        return this.getDictionary(dictionary).lookup(group, key, this.currentApplicationType);
    }

    private Dictionary getDictionary(String dictionary) {
        if (!this.dictionaries.containsKey(dictionary)) {
            this.dictionaries.put(dictionary, new GlobalDictionary());
        }
        return (Dictionary)this.dictionaries.get(dictionary);
    }

    public void store(String dictionary, Group group, QName key, ScalarValue valueToEncode) {
        if (group.hasTypeReference()) {
            this.currentApplicationType = group.getTypeReference();
        }
        this.getDictionary(dictionary).store(group, this.currentApplicationType, key, valueToEncode);
    }

    public void reset() {
        for (Dictionary dict : this.dictionaries.values()) {
            dict.reset();
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void newMessage(MessageTemplate template) {
        this.currentApplicationType = template.hasTypeReference() ? template.getTypeReference() : FastConstants.ANY_TYPE;
    }

    public void setCurrentApplicationType(QName name) {
        this.currentApplicationType = name;
    }

    public TemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    public void setTemplateRegistry(TemplateRegistry registry) {
        this.templateRegistry = registry;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void startTrace() {
        if (this.isTraceEnabled()) {
            if (this.decodeTrace == null) {
                this.setDecodeTrace(new BasicDecodeTrace());
            }
            if (this.encodeTrace == null) {
                this.setEncodeTrace(new BasicEncodeTrace());
            }
        }
    }

    public void setTraceEnabled(boolean enabled) {
        this.traceEnabled = enabled;
    }

    public void setEncodeTrace(BasicEncodeTrace encodeTrace) {
        this.encodeTrace = encodeTrace;
    }

    public Trace getEncodeTrace() {
        return this.encodeTrace;
    }

    public void setDecodeTrace(Trace decodeTrace) {
        this.decodeTrace = decodeTrace;
    }

    public Trace getDecodeTrace() {
        return this.decodeTrace;
    }

    public Cache getCache(QName key) {
        if (!this.caches.containsKey(key)) {
            this.caches.put(key, new UnboundedCache());
        }
        return (Cache)this.caches.get(key);
    }

    public void store(QName key, int index, ScalarValue value) {
        if (!this.caches.containsKey(key)) {
            this.caches.put(key, new UnboundedCache());
        }
        ((Cache)this.caches.get(key)).store(index, value);
    }

    public FastMessageLogger getLogger() {
        if (this.logger == null) {
            return this.parentContext.getLogger();
        }
        return this.logger;
    }

    public void setLogger(FastMessageLogger logger) {
        this.logger = logger;
    }
}

