/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.consumer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageBlockReader;
import org.openfast.MessageInputStream;
import org.openfast.error.FastException;
import org.openfast.examples.MessageBlockReaderFactory;
import org.openfast.session.Connection;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class FastMessageConsumer {
    private final Endpoint endpoint;
    private final TemplateRegistry templateRegistry;
    protected final MessageBlockReaderFactory messageBlockReaderFactory;
    protected final boolean shouldResetOnEveryMessage;

    public FastMessageConsumer(Endpoint endpoint, File templatesFile) {
        this(endpoint, templatesFile, new MessageBlockReaderFactory(), false);
    }

    public FastMessageConsumer(Endpoint endpoint, File templatesFile, MessageBlockReaderFactory messageBlockReaderFactory, boolean shouldResetOnEveryMessage) {
        this.endpoint = endpoint;
        XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader();
        loader.setLoadTemplateIdFromAuxId(true);
        try {
            loader.load(new FileInputStream(templatesFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.templateRegistry = loader.getTemplateRegistry();
        this.messageBlockReaderFactory = messageBlockReaderFactory;
        this.shouldResetOnEveryMessage = shouldResetOnEveryMessage;
    }

    public void start() throws FastConnectionException, IOException {
        final Connection connection = this.endpoint.connect();
        Context context = new Context();
        context.setTemplateRegistry(this.templateRegistry);
        MessageInputStream msgInStream = new MessageInputStream(connection.getInputStream(), context);
        MessageBlockReader msgBlockReader = this.messageBlockReaderFactory.create();
        msgInStream.setBlockReader(msgBlockReader);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                connection.close();
            }
        });
        while (true) {
            try {
                while (true) {
                    Message message = msgInStream.readMessage();
                    System.out.println(String.valueOf(msgBlockReader.toString()) + ' ' + message.toString());
                    if (!this.shouldResetOnEveryMessage) continue;
                    msgInStream.reset();
                }
            }
            catch (FastException e) {
                System.err.println(e.getMessage());
                continue;
            }
            break;
        }
    }
}

