/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Stack;

public class XmlWriter {
    private static final int DEFAULT_TAB_SIZE = 4;
    private final PrintWriter writer;
    private int tabSize = 4;
    private String indent = "";
    private boolean open;
    private boolean hasChildren;
    private Stack elementStack = new Stack();
    private boolean processingInstructionsEnabled;
    private boolean started = false;

    public XmlWriter(OutputStream destination) {
        this.writer = new PrintWriter(new OutputStreamWriter(destination));
    }

    public void setEnableProcessingInstructions(boolean enableProcessingInstructions) {
        this.processingInstructionsEnabled = enableProcessingInstructions;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public void start(String nodeName) {
        if (!this.started && this.processingInstructionsEnabled) {
            this.writer.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        }
        this.started = true;
        this.hasChildren = false;
        if (this.open) {
            this.writer.println(">");
        }
        this.writer.print(String.valueOf(this.indent) + "<" + nodeName);
        this.open = true;
        this.indent();
        this.elementStack.push(nodeName);
    }

    public void addAttribute(String name, String value) {
        if (!this.open) {
            throw new IllegalStateException("Cannot add attribute here.");
        }
        this.writer.print(" " + name + "=\"" + value + "\"");
    }

    public void end() {
        this.unindent();
        String nodeName = (String)this.elementStack.pop();
        if (this.open || !this.hasChildren) {
            this.writer.println("/>");
        } else {
            this.writer.println(String.valueOf(this.indent) + "</" + nodeName + ">");
        }
        this.writer.flush();
        this.hasChildren = true;
        this.open = false;
    }

    private void indent() {
        int i = 0;
        while (i < this.tabSize) {
            this.indent = String.valueOf(this.indent) + " ";
            ++i;
        }
    }

    private void unindent() {
        this.indent = this.indent.substring(this.tabSize);
    }
}

