/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.mem.BunchMap;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Iterator;

public class HashedBunchMap
extends HashCommon
implements BunchMap {
    protected Object[] values;

    public HashedBunchMap() {
        super(10);
        this.values = new Object[this.capacity];
    }

    public void clear() {
        for (int i = 0; i < this.capacity; ++i) {
            this.values[i] = null;
            this.keys[i] = null;
        }
    }

    public Object get(Object key) {
        int slot = this.findSlot(key);
        return slot < 0 ? this.values[~slot] : null;
    }

    public void put(Object key, Object value) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.values[slot ^ 0xFFFFFFFF] = value;
        } else {
            this.keys[slot] = key;
            this.values[slot] = value;
            ++this.size;
            if (this.size == this.threshold) {
                this.grow();
            }
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        Object[] oldValues = this.values;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Object[this.capacity];
        this.values = new Object[this.capacity];
        for (int i = 0; i < oldCapacity; ++i) {
            Object key = oldContents[i];
            if (key == null) continue;
            int j = this.findSlot(key);
            this.keys[j] = key;
            this.values[j] = oldValues[i];
        }
    }

    public void remove(Object key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.removeFrom(~slot);
        }
    }

    protected void removeAssociatedValues(int here) {
        this.values[here] = null;
    }

    protected void moveAssociatedValues(int here, int scan) {
        this.values[here] = this.values[scan];
    }

    public Iterator keyIterator() {
        return new NiceIterator(){
            int index;
            {
                this.index = HashedBunchMap.this.capacity - 1;
            }

            public boolean hasNext() {
                while (this.index >= 0 && HashedBunchMap.this.keys[this.index] == null) {
                    --this.index;
                }
                return this.index >= 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    this.noElements("bunch map keys");
                }
                return HashedBunchMap.this.keys[this.index--];
            }
        };
    }
}

