/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.KSNN;

import java.util.StringTokenizer;
import keel.Algorithms.Lazy_Learning.LazyAlgorithm;
import org.core.Files;

public class KSNN
extends LazyAlgorithm {
    int K;
    double[] further;
    boolean[] selected;

    public KSNN(String script) {
        this.readDataFiles(script);
        this.name = "Center NN";
        this.further = new double[this.trainData.length];
        this.selected = new boolean[this.trainData.length];
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.K = Integer.parseInt(tokens.nextToken().substring(1));
    }

    public void getFurtherNeighbor() {
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (int instance = 0; instance < this.trainData.length; ++instance) {
            int i;
            for (i = 0; i < this.K; ++i) {
                nearestN[i] = -1;
                minDist[i] = Double.POSITIVE_INFINITY;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                double dist = this.euclideanDistance(this.trainData[instance], this.trainData[i]);
                if (!(dist > 0.0)) continue;
                boolean stop = false;
                for (int j = 0; j < this.K && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.K - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            this.further[instance] = minDist[this.K - 1];
        }
    }

    @Override
    protected int evaluate(double[] example) {
        int i;
        int[] votes = new int[this.nClasses];
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i = 0; i < this.trainData.length; ++i) {
            this.selected[i] = false;
        }
        for (i = 0; i < this.K; ++i) {
            nearestN[i] = -1;
            minDist[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            double dist = this.euclideanDistance(example, this.trainData[i]);
            if (dist > 0.0) {
                boolean stop = false;
                for (int j = 0; j < this.K && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.K - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            if (!(dist < this.further[i])) continue;
            this.selected[i] = true;
        }
        for (i = 0; i < this.K; ++i) {
            this.selected[nearestN[i]] = true;
        }
        for (i = 0; i < this.nClasses; ++i) {
            votes[i] = 0;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            if (!this.selected[i]) continue;
            int n = this.trainOutput[i];
            votes[n] = votes[n] + 1;
        }
        int output = -1;
        int maxVotes = 0;
        for (i = 0; i < this.nClasses; ++i) {
            if (maxVotes >= votes[i]) continue;
            maxVotes = votes[i];
            output = i;
        }
        return output;
    }
}

