/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.ClassifierKernel;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import keel.Algorithms.Statistical_Classifiers.ClassifierKernel.Kernel;
import org.core.Randomize;

public class ClassifierKernel {
    static Randomize rand;

    private static void kernelClassifier(boolean tty, ProcessConfig pc) {
        try {
            ProcessDataset pd = new ProcessDataset();
            String line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processClassifierDataset(line, true);
            } else {
                pd.oldClusteringProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            pd.showDatasetStatistics();
            double[][] X = pd.getX();
            int[] C = pd.getC();
            int[] Ct = new int[C.length];
            int nClass = pd.getNclasses();
            double[] maxInput = pd.getImaximum();
            double[] minInput = pd.getIminimum();
            int[] nInputFolds = new int[nInputs];
            double s = ProcessConfig.parKernel;
            System.out.println("Sigma=" + s);
            for (int i = 0; i < X.length; ++i) {
                Ct[i] = -1;
            }
            Kernel K = new Kernel(X, C, s, nClass);
            double faults = 0.0;
            try {
                for (int i = 0; i < X.length; ++i) {
                    int theClass = K.internalClassifier(X[i]);
                    if (theClass != C[i]) {
                        faults += 1.0;
                    }
                    Ct[i] = theClass;
                }
                System.out.println("Train error=" + (faults /= (double)nData));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.trainingResults(C, Ct);
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processClassifierDataset(line, false);
            } else {
                pdt.oldClusteringProcess(line);
            }
            int nTest = pdt.getNdata();
            int npVariables = pdt.getNvariables();
            int npInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npInputs != nInputs) {
                throw new IOException("IOERR in test");
            }
            double[][] Xp = pdt.getX();
            int[] Cp = pdt.getC();
            int[] Co = new int[Cp.length];
            try {
                faults = 0.0;
                for (int i = 0; i < Xp.length; ++i) {
                    int clase = K.internalClassifier(Xp[i]);
                    if (clase != Cp[i]) {
                        faults += 1.0;
                    }
                    Co[i] = clase;
                }
                System.out.println("Test error=" + (faults /= (double)Cp.length));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.results(Cp, Co);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Examples file not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ClassifierKernel ck = new ClassifierKernel();
        ClassifierKernel.kernelClassifier(tty, pc);
    }
}

