#' Mock the Unix \command{touch} Utility
#'
#' Creating a file or ensuring a file's modification time changes.
#'
#' @param path Path to the file to be touched.
#' @family file utilities
#' @return The Path to the file touched.
#' @export
#' @examples
#' file <- tempfile()
#' touch(file)
#' t1 <- file.mtime(file)
#' touch(file)
#' t2 <- file.mtime(file)
#' t1 < t2
#' file <- file.path(tempfile(), "path", "not", "there.txt")
#' touch(file)
#' file.exists(file)
touch <- function(path) {
    if (!file.exists(path)) {
        if (!dir.exists(dirname(path))) dir.create(dirname(path),
                                                   recursive = TRUE)
        cat("# This file was generated by fritools::touch()", file = path)
    } else {
        tmp <- tempfile()
        on.exit(unlink(tmp))
        file.copy(path, tmp)
        if (file.mtime(tmp) <= file.mtime(path)) Sys.sleep(2)
        file.copy(tmp, path, overwrite = TRUE)
    }
    return(invisible(path))
}
