/*
 * Decompiled with CFR 0.152.
 */
package mrmc.chart;

import java.awt.Dimension;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarGraph
extends JFrame {
    private static final long serialVersionUID = 1L;

    public BarGraph(String title, String xaxis, String yaxis, TreeMap<String, Double> treeMap) {
        super(title);
        CategoryDataset dataset = this.createDataset(treeMap, xaxis);
        JFreeChart chart = this.createChart(dataset, title, xaxis, yaxis);
        LegendTitle legend = chart.getLegend();
        legend.setVisible(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset(TreeMap<String, Double> treeMap, String xaxis) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry<String, Double> e : treeMap.entrySet()) {
            String key = e.getKey();
            double value = e.getValue();
            dataset.addValue(value, (Comparable)((Object)String.valueOf(key)), (Comparable)((Object)xaxis));
        }
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset, String title, String xaxis, String yaxis) {
        JFreeChart chart = ChartFactory.createBarChart(title, xaxis, yaxis, dataset, PlotOrientation.VERTICAL, true, true, false);
        return chart;
    }
}

