/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph;

import java.util.Comparator;
import java.util.TreeSet;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.GraphImpl;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.WeightedEdge;
import salvo.jesus.graph.WeightedGraph;
import salvo.jesus.graph.adaptor.GraphDelegator;
import salvo.jesus.graph.algorithm.MinimumSpanningTreeAlgorithm;
import salvo.jesus.graph.algorithm.ShortestPathAlgorithm;

class WeightedGraphWeakImpl
extends GraphDelegator
implements WeightedGraph {
    MinimumSpanningTreeAlgorithm minimumSpanningTreeAlgorithm;
    ShortestPathAlgorithm shortestPathAlgorithm;

    public WeightedGraphWeakImpl(GraphImpl graph, MinimumSpanningTreeAlgorithm minspantreealgo, ShortestPathAlgorithm shortestpathalgo) {
        super(graph);
        this.minimumSpanningTreeAlgorithm = minspantreealgo;
        this.shortestPathAlgorithm = shortestpathalgo;
    }

    public WeightedEdge addEdge(Vertex v1, Vertex v2, double weight) throws Exception {
        WeightedEdge edge = (WeightedEdge)this.addEdge(v1, v2);
        edge.setWeight(weight);
        return edge;
    }

    public void addEdge(Edge edge) throws Exception {
        this.addEdge((WeightedEdge)edge);
    }

    public void setMinimumSpanningTreeAlgorithm(MinimumSpanningTreeAlgorithm algo) {
        this.minimumSpanningTreeAlgorithm = algo;
    }

    public void setShortestPathAlgorithm(ShortestPathAlgorithm algo) {
        this.shortestPathAlgorithm = algo;
    }

    public Vertex getClosest(Vertex v) {
        if (this.getEdges(v).size() == 0) {
            return null;
        }
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object obj1, Object obj2) {
                WeightedEdge edge1 = (WeightedEdge)obj1;
                WeightedEdge edge2 = (WeightedEdge)obj2;
                if (edge1.getWeight() < edge2.getWeight()) {
                    return -1;
                }
                if (edge1.getWeight() > edge2.getWeight()) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return obj.equals(this);
            }
        });
        set.addAll(this.getEdges(v));
        Edge e = (Edge)set.first();
        return e.getOppositeVertex(v);
    }

    public WeightedGraph minimumSpanningTree() {
        return this.minimumSpanningTreeAlgorithm.minimumSpanningTree();
    }

    public WeightedGraph shortestPath(Vertex vertex) {
        return this.shortestPathAlgorithm.shortestPath(vertex);
    }
}

