/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.UniformFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.ModelReader;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import gnu.trove.TDoubleArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestUniformFactor
extends TestCase {
    static String mdlstr = "VAR u1 u2 : continuous\nu1 ~ Uniform 0.0 10.0\nu2 ~ Uniform 5.0 7.0\n";

    public TestUniformFactor(String name) {
        super(name);
    }

    public void testVarSet() {
        Variable var = new Variable(-1);
        UniformFactor f = new UniformFactor(var, -1.0, 1.5);
        TestUniformFactor.assertEquals((int)1, (int)f.varSet().size());
        TestUniformFactor.assertTrue((boolean)f.varSet().contains(var));
    }

    public void testSample() {
        Variable var = new Variable(-1);
        Randoms r = new Randoms(2343);
        UniformFactor f = new UniformFactor(var, -1.0, 1.5);
        TDoubleArrayList lst = new TDoubleArrayList();
        for (int i = 0; i < 10000; ++i) {
            Assignment assn = f.sample(r);
            lst.add(assn.getDouble(var));
        }
        double[] vals = lst.toNativeArray();
        double mean = MatrixOps.mean(vals);
        TestUniformFactor.assertEquals((double)0.25, (double)mean, (double)0.01);
    }

    public void testSliceInFg() throws IOException {
        ModelReader reader = new ModelReader();
        FactorGraph fg = reader.readModel(new BufferedReader(new StringReader(mdlstr)));
        Variable u1 = fg.findVariable("u1");
        Variable u2 = fg.findVariable("u2");
        Assignment assn = new Assignment(new Variable[]{u1, u2}, new double[]{6.0, 6.0});
        FactorGraph fg2 = (FactorGraph)fg.slice(assn);
        fg2.dump();
        TestUniformFactor.assertEquals((int)2, (int)fg2.factors().size());
        TestUniformFactor.assertEquals((double)0.05, (double)fg2.value(new Assignment()), (double)1.0E-5);
        fg2.addFactor(new ConstantFactor(10.0));
        TestUniformFactor.assertEquals((double)0.5, (double)fg2.value(new Assignment()), (double)1.0E-5);
    }

    public static TestSuite suite() {
        return new TestSuite(TestUniformFactor.class);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestUniformFactor(args[i]));
            }
        } else {
            theSuite = TestUniformFactor.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

