/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.regular.Regular;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.constraints.automaton.Transition;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class StretchPathManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof List) {
            List stretchParameters = (List)parameters;
            IntDomainVar[] vars = solver.getVar(variables);
            IntDomainVar[] tmpVars = new IntDomainVar[vars.length];
            System.arraycopy(vars, 0, tmpVars, 0, vars.length);
            ArrayList<Integer> alphabet = new ArrayList<Integer>();
            for (int i = 0; i < vars.length; ++i) {
                DisposableIntIterator it = tmpVars[i].getDomain().getIterator();
                while (it.hasNext()) {
                    int val = it.next();
                    if (alphabet.contains(val)) continue;
                    alphabet.add(val);
                }
                it.dispose();
            }
            int nbStates = 1;
            HashMap<Integer, Integer> tab = new HashMap<Integer, Integer>();
            LinkedList<Transition> t = new LinkedList<Transition>();
            LinkedList<Integer> fs = new LinkedList<Integer>();
            fs.add(0);
            for (int[] vals : stretchParameters) {
                int valState = nbStates++;
                tab.put(vals[0], valState);
                t.add(new Transition(0, vals[0], valState));
                if (vals[1] != 1) continue;
                fs.add(valState);
            }
            for (Integer val : alphabet) {
                if (tab.containsKey(val)) continue;
                t.add(new Transition(0, val, 0));
            }
            for (int[] vals : stretchParameters) {
                int lastState = (Integer)tab.get(vals[0]);
                for (int j = 2; j <= vals[2]; ++j) {
                    int newState = nbStates++;
                    t.add(new Transition(lastState, vals[0], newState));
                    if (j > vals[1]) {
                        for (int i1 = 0; i1 < alphabet.size(); ++i1) {
                            Object anAlphabet = alphabet.get(i1);
                            int val = (Integer)anAlphabet;
                            if (vals[0] == val) continue;
                            if (tab.containsKey(val)) {
                                int dest = (Integer)tab.get(val);
                                t.add(new Transition(lastState, val, dest));
                                continue;
                            }
                            t.add(new Transition(lastState, val, 0));
                        }
                    }
                    if (j >= vals[1]) {
                        fs.add(newState);
                    }
                    lastState = newState;
                }
                for (Integer val : alphabet) {
                    if (vals[0] == val) continue;
                    if (tab.containsKey(val)) {
                        int dest = (Integer)tab.get(val);
                        t.add(new Transition(lastState, val, dest));
                        continue;
                    }
                    t.add(new Transition(lastState, val, 0));
                }
            }
            DFA auto = new DFA(t, fs, vars.length);
            return new Regular(auto, tmpVars, solver.getEnvironment());
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }
}

