/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.cp.solver.constraints.set.AbstractBoundOfASet;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public final class MaxOfASet
extends AbstractBoundOfASet {
    public MaxOfASet(IEnvironment environment, IntDomainVar[] intvars, SetVar setvar, AbstractBoundOfASet.EmptySetPolicy emptySetPolicy) {
        super(environment, intvars, setvar, emptySetPolicy);
    }

    @Override
    protected boolean removeFromEnv(int idx) throws ContradictionException {
        return this.removeGreaterFromEnv(idx, this.ivars[0].getSup());
    }

    @Override
    protected int updateIndexOfCandidateVariable() {
        int maxMax = Integer.MIN_VALUE;
        int maxMaxIdx = -1;
        int maxMax2 = Integer.MIN_VALUE;
        DisposableIntIterator iter = this.getSetDomain().getEnveloppeIterator();
        while (iter.hasNext()) {
            int idx = iter.next() + 1;
            int val = this.ivars[idx].getSup();
            if (val >= maxMax) {
                maxMax2 = maxMax;
                maxMax = val;
                maxMaxIdx = idx;
                continue;
            }
            if (val <= maxMax2) continue;
            maxMax2 = val;
        }
        iter.dispose();
        return maxMax2 < this.ivars[0].getInf() ? maxMaxIdx : -1;
    }

    protected final int maxInf() {
        DisposableIntIterator iter = this.getSetDomain().getKernelIterator();
        int max = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            int val = this.ivars[1 + iter.next()].getInf();
            if (val <= max) continue;
            max = val;
        }
        iter.dispose();
        return max;
    }

    protected final int maxSup() {
        if (this.isNotEmptySet()) {
            int max = Integer.MIN_VALUE;
            DisposableIntIterator iter = this.getSetDomain().getEnveloppeIterator();
            while (iter.hasNext()) {
                int val = this.ivars[1 + iter.next()].getSup();
                if (val <= max) continue;
                max = val;
            }
            iter.dispose();
            return max;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateKernelSup() throws ContradictionException {
        int maxValue = this.ivars[0].getSup();
        DisposableIntIterator iter = this.svars[0].getDomain().getKernelIterator();
        try {
            while (iter.hasNext()) {
                int i = 1 + iter.next();
                this.ivars[i].updateSup(maxValue, this, false);
            }
        }
        finally {
            iter.dispose();
        }
    }

    @Override
    public void filter() throws ContradictionException {
        do {
            this.updateBoundSup(this.maxSup());
        } while (this.remFromEnveloppe());
        this.updateBoundInf(this.maxInf());
        this.updateKernelSup();
        this.onlyOneCandidatePropagation();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        int i;
        if (idx >= 2 && this.isInEnveloppe(i = idx - 2)) {
            if (this.isInKernel(i)) {
                this.updateBoundInf(this.maxInf());
            } else {
                while (this.remFromEnveloppe()) {
                    this.updateBoundSup(this.maxSup());
                }
            }
        }
        this.onlyOneCandidatePropagation();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx >= 2) {
            int i = idx - 2;
            if (this.isInEnveloppe(i)) {
                do {
                    this.updateBoundSup(this.maxSup());
                } while (this.remFromEnveloppe());
                this.onlyOneCandidatePropagation();
            }
        } else {
            while (this.remFromEnveloppe()) {
                this.updateBoundSup(this.maxSup());
            }
            this.updateKernelSup();
            this.onlyOneCandidatePropagation();
        }
    }

    @Override
    public void awakeOnRem() throws ContradictionException {
        do {
            this.updateBoundSup(this.maxSup());
        } while (this.remFromEnveloppe());
        this.onlyOneCandidatePropagation();
    }

    @Override
    public void awakeOnKer() throws ContradictionException {
        this.updateBoundInf(this.maxInf());
        this.onlyOneCandidatePropagation();
    }

    @Override
    protected int getSatisfiedValue(DisposableIntIterator iter) {
        int v = Integer.MIN_VALUE;
        do {
            v = Math.max(v, this.ivars[1 + iter.next()].getVal());
        } while (iter.hasNext());
        iter.dispose();
        return v;
    }

    @Override
    public String pretty() {
        return this.pretty("max");
    }
}

