/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.structure.Couple;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.event.VarEvent;
import choco.kernel.solver.propagation.listener.IntPropagator;
import choco.kernel.solver.variables.integer.IntDomain;
import gnu.trove.TIntHashSet;

public class IntVarEvent<C extends AbstractSConstraint>
extends VarEvent<IntDomainVarImpl> {
    public static final int INCINF = 0;
    public static final int DECSUP = 1;
    public static final int REMVAL = 2;
    public static final int INSTINT = 3;
    public static final int NO_MASK = 0;
    public static final int INCINF_MASK = 1;
    @Deprecated
    public static final int INCINFbitvector = 1;
    public static final int DECSUP_MASK = 2;
    @Deprecated
    public static final int DECSUPbitvector = 2;
    public static final int BOUNDS_MASK = 3;
    @Deprecated
    public static final int BOUNDSbitvector = 3;
    public static final int REMVAL_MASK = 4;
    @Deprecated
    public static final int REMVALbitvector = 4;
    public static final int INSTINT_MASK = 8;
    @Deprecated
    public static final int INSTINTbitvector = 8;
    final IntDomain _domain;
    final TIntHashSet counters = new TIntHashSet();
    public static long propagations = 0L;
    public static final int[] EVENTS = new int[]{1, 2, 4, 8};

    public IntVarEvent(IntDomainVarImpl var) {
        super(var);
        this._domain = var.getDomain();
        this.eventType = 0;
    }

    public String toString() {
        return "VarEvt(" + ((IntDomainVarImpl)this.modifiedVar).pretty() + ")[" + this.eventType + ":" + ((this.eventType & 1) != 0 ? "I" : "") + ((this.eventType & 2) != 0 ? "S" : "") + ((this.eventType & 4) != 0 ? "r" : "") + ((this.eventType & 8) != 0 ? "X" : "") + "]";
    }

    @Override
    public void clear() {
        this.eventType = 0;
        this.cause = null;
        this._domain.clearDeltaDomain();
    }

    @Override
    protected boolean release() {
        return this._domain.releaseDeltaDomain();
    }

    @Override
    protected void freeze() {
        this._domain.freezeDeltaDomain();
        this.cause = null;
        this.eventType = 0;
    }

    public boolean getReleased() {
        return this._domain.getReleasedDeltaDomain();
    }

    @Override
    public boolean propagateEvent() throws ContradictionException {
        int evtType = this.eventType;
        AbstractSConstraint evtCause = (AbstractSConstraint)this.cause;
        this.freeze();
        this.counters.clear();
        if ((this.propagatedEvents & 8) != 0 && (evtType & 8) != 0) {
            this.propagateInstEvent(evtCause);
        }
        if ((this.propagatedEvents & 1) != 0 && (evtType & 1) != 0) {
            this.propagateInfEvent(evtCause);
        }
        if ((this.propagatedEvents & 2) != 0 && (evtType & 2) != 0) {
            this.propagateSupEvent(evtCause);
        }
        if ((this.propagatedEvents & 4) != 0 && (evtType & 4) != 0) {
            this.propagateRemovalsEvent(evtCause);
        }
        propagations += (long)this.counters.size();
        return this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateInstEvent(C evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        DisposableIterator<Couple<C>> cit = v.getActiveConstraints(8, evtCause);
        try {
            while (cit.hasNext()) {
                Couple cc = (Couple)cit.next();
                this.counters.add(cc.i);
                ((IntPropagator)((Object)((AbstractSConstraint)cc.c))).awakeOnInst(cc.i);
            }
        }
        finally {
            cit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateInfEvent(C evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        DisposableIterator<Couple<C>> cit = v.getActiveConstraints(1, evtCause);
        try {
            while (cit.hasNext()) {
                Couple cc = (Couple)cit.next();
                this.counters.add(cc.i);
                ((IntPropagator)((Object)((AbstractSConstraint)cc.c))).awakeOnInf(cc.i);
            }
        }
        finally {
            cit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateSupEvent(C evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        DisposableIterator<Couple<C>> cit = v.getActiveConstraints(2, evtCause);
        try {
            while (cit.hasNext()) {
                Couple cc = (Couple)cit.next();
                this.counters.add(cc.i);
                ((IntPropagator)((Object)((AbstractSConstraint)cc.c))).awakeOnSup(cc.i);
            }
        }
        finally {
            cit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateRemovalsEvent(C evtCause) throws ContradictionException {
        IntDomainVarImpl v = (IntDomainVarImpl)this.modifiedVar;
        DisposableIterator<Couple<C>> cit = v.getActiveConstraints(4, evtCause);
        try {
            while (cit.hasNext()) {
                Couple cc = (Couple)cit.next();
                this.counters.add(cc.i);
                DisposableIntIterator iter = this._domain.getDeltaIterator();
                try {
                    ((IntPropagator)((Object)((AbstractSConstraint)cc.c))).awakeOnRemovals(cc.i, iter);
                }
                finally {
                    iter.dispose();
                }
            }
        }
        finally {
            cit.dispose();
        }
    }

    private int promoteEvent(int basicEvt) {
        switch (basicEvt) {
            case 3: {
                return 15;
            }
            case 0: {
                return 5;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 4;
            }
        }
        return 1 << basicEvt;
    }

    @Override
    public void recordEventTypeAndCause(int basicEvt, SConstraint constraint, boolean forceAwake) {
        if (this.eventType == 0) {
            this.eventType = this.promoteEvent(basicEvt);
            if (!forceAwake) {
                this.cause = constraint;
            }
        } else {
            this.eventType |= this.promoteEvent(basicEvt);
            if (forceAwake || this.cause != constraint) {
                this.cause = null;
            }
        }
    }
}

