/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;

public class Blocks {
    private Graph graph;
    private Map<Node, Integer> enter = new LinkedHashMap<Node, Integer>();
    private Map<Node, Integer> up = new LinkedHashMap<Node, Integer>();
    private Stack<Edge> stack = new Stack();
    private Set<Set<Node>> components;
    private Set<Node> cutpoints;
    private Node root;
    private Map<Node, List<Set<Node>>> intersection;
    private Map<Node, Set<Node>> componentOf;
    private Map<Set<Node>, Set<Node>> cpsOf;
    private int rootChildren;
    private int time;

    public Blocks(Graph graph) {
        this.root = graph.vertexSet().iterator().next();
        this.components = new LinkedHashSet<Set<Node>>();
        this.cutpoints = new LinkedHashSet<Node>();
        this.graph = graph;
        if (graph.vertexSet().size() > 1) {
            this.dfs(this.root, null);
        } else {
            LinkedHashSet<Node> component = new LinkedHashSet<Node>();
            component.add(this.root);
            this.components.add(component);
        }
        this.postProcessing();
    }

    public Set<Node> componentOf(Node node) {
        return this.componentOf.get(node);
    }

    public Set<Node> cutpointsOf(Set<Node> component) {
        return this.cpsOf.get(component);
    }

    public List<Set<Node>> incidentBlocks(Node cp) {
        return this.intersection.get(cp);
    }

    private void postProcessing() {
        this.cpsOf = new HashMap<Set<Node>, Set<Node>>();
        this.componentOf = new HashMap<Node, Set<Node>>();
        this.intersection = new HashMap<Node, List<Set<Node>>>();
        for (Set<Node> component : this.components) {
            for (Node cp : this.cutpoints) {
                if (!component.contains(cp)) continue;
                if (!this.intersection.containsKey(cp)) {
                    this.intersection.put(cp, new ArrayList());
                }
                this.intersection.get(cp).add(component);
                if (!this.cpsOf.containsKey(component)) {
                    this.cpsOf.put(component, new HashSet());
                }
                this.cpsOf.get(component).add(cp);
            }
        }
        for (Set<Node> component : this.components()) {
            for (Node node : component) {
                this.componentOf.put(node, component);
            }
        }
    }

    public void dfs(Node v, Node parent) {
        ++this.time;
        this.enter.put(v, this.time);
        this.up.put(v, this.time);
        for (Node u : this.graph.neighborListOf(v)) {
            if (u == parent) continue;
            if (!this.enter.containsKey(u)) {
                this.stack.add(this.graph.getEdge(v, u));
                if (v == this.root) {
                    ++this.rootChildren;
                }
                this.dfs(u, v);
                if (this.up.get(u) >= this.enter.get(v)) {
                    Edge edge;
                    LinkedHashSet<Node> component = new LinkedHashSet<Node>();
                    Edge expected = this.graph.getEdge(v, u);
                    do {
                        edge = this.stack.pop();
                        component.add(this.graph.getEdgeSource(edge));
                        component.add(this.graph.getEdgeTarget(edge));
                    } while (edge != expected);
                    this.components.add(component);
                    this.cutpoints.add(v);
                }
                if (this.up.get(u) >= this.up.get(v)) continue;
                this.up.put(v, this.up.get(u));
                continue;
            }
            if (this.up.get(v) <= this.enter.get(u)) continue;
            this.up.put(v, this.enter.get(u));
        }
        if (this.rootChildren < 2) {
            this.cutpoints.remove(this.root);
        }
    }

    public Set<Set<Node>> components() {
        return this.components;
    }

    public Set<Node> cutpoints() {
        return this.cutpoints;
    }
}

