/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.EvaluationMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Evaluator<T> {
    private List<EvaluationMonitor<T>> listeners;

    public Evaluator(EvaluationMonitor<T> ... aListeners) {
        if (aListeners != null) {
            ArrayList<EvaluationMonitor<T>> listenersList = new ArrayList<EvaluationMonitor<T>>(aListeners.length);
            for (EvaluationMonitor<T> evaluationMonitor : aListeners) {
                if (evaluationMonitor == null) continue;
                listenersList.add(evaluationMonitor);
            }
            this.listeners = Collections.unmodifiableList(listenersList);
        } else {
            this.listeners = Collections.emptyList();
        }
    }

    protected T processSample(T reference) {
        return null;
    }

    public void evaluateSample(T sample) {
        block4: {
            T predicted = this.processSample(sample);
            if (this.listeners.isEmpty()) break block4;
            if (sample.equals(predicted)) {
                for (EvaluationMonitor<T> listener : this.listeners) {
                    listener.correctlyClassified(predicted, predicted);
                }
            } else {
                for (EvaluationMonitor<T> listener : this.listeners) {
                    listener.missclassified(sample, predicted);
                }
            }
        }
    }

    public void evaluate(ObjectStream<T> samples) throws IOException {
        T sample;
        while ((sample = samples.read()) != null) {
            this.evaluateSample(sample);
        }
    }
}

