/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Image;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class SystemTrayHelper {
    private static Object systemTray;
    private static boolean initDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getSystemTray() {
        if (!initDone) {
            try {
                Class<?> clazz = Class.forName("java.awt.SystemTray");
                Method method = clazz.getMethod("isSupported", new Class[0]);
                boolean bl = Boolean.TRUE.equals(method.invoke(clazz, new Object[0]));
                if (bl) {
                    method = clazz.getMethod("getSystemTray", new Class[0]);
                    systemTray = method.invoke(clazz, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                System.err.println("Error with system tray: " + throwable.getMessage());
            }
            finally {
                initDone = true;
            }
        }
        return systemTray;
    }

    public static void hideSystemTrayIcon(Object object) {
        if (object != null && SystemTrayHelper.getSystemTray() != null) {
            try {
                Method method = systemTray.getClass().getMethod("remove", object.getClass());
                method.invoke(systemTray, object);
            }
            catch (Throwable throwable) {
                System.err.println("Error with system tray: " + throwable.getMessage());
            }
        }
    }

    public static void updateTrayIcon(Object object, Image image, String string) {
        if (SystemTrayHelper.getSystemTray() != null) {
            try {
                Class<?> clazz = Class.forName("java.awt.TrayIcon");
                Method method = clazz.getMethod("setImage", Image.class);
                method.invoke(object, image);
                method = clazz.getMethod("setToolTip", String.class);
                method.invoke(object, string);
            }
            catch (Throwable throwable) {
                System.err.println("Error with system tray: " + throwable.getMessage());
            }
        }
    }

    public static Object displaySystemTrayIcon(Image image, String string) {
        Object object = null;
        if (SystemTrayHelper.getSystemTray() != null) {
            try {
                Class<?> clazz = Class.forName("java.awt.TrayIcon");
                Constructor<?> constructor = clazz.getConstructor(Image.class, String.class);
                object = constructor.newInstance(image, string);
                Method method = systemTray.getClass().getMethod("add", object.getClass());
                method.invoke(systemTray, object);
            }
            catch (Throwable throwable) {
                System.err.println("Error with system tray: " + throwable.getMessage());
            }
        }
        return object;
    }

    public static void showTrayMessage(Object object, String string, String string2, String string3) {
        if (SystemTrayHelper.getSystemTray() != null) {
            try {
                Class<?> clazz = Class.forName("java.awt.TrayIcon");
                Class<?> clazz2 = Class.forName("java.awt.TrayIcon$MessageType");
                Method method = clazz2.getMethod("valueOf", String.class);
                Object object2 = method.invoke(clazz2, string3);
                Method method2 = clazz.getMethod("displayMessage", String.class, String.class, clazz2);
                method2.invoke(object, string, string2, object2);
            }
            catch (Throwable throwable) {
                System.err.println("Error with system tray: " + throwable.getMessage());
            }
        }
    }

    static {
        initDone = false;
    }
}

