/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

final class InvariantRanker {
    private final int[] aux;
    private static final int INSERTION_SORT_THRESHOLD = 42;

    InvariantRanker(int n) {
        this.aux = new int[n];
    }

    int rank(int[] currEq, int[] nextEq, int n, long[] curr, long[] prev) {
        this.sortBy(currEq, 0, n, curr, prev);
        int nEquivalent = 0;
        int nRanks = 1 + curr.length - n;
        int[] tmp = this.aux;
        int u = currEq[0];
        int labelTick = tmp[u] = (int)prev[u];
        long label = labelTick;
        for (int i = 1; i < n; ++i) {
            int v = currEq[i];
            labelTick = prev[v] != (long)tmp[u] ? (int)prev[v] : ++labelTick;
            if (curr[v] != curr[u] || prev[v] != (long)tmp[u]) {
                tmp[v] = (int)prev[v];
                prev[v] = labelTick;
                label = labelTick;
                ++nRanks;
            } else {
                if (nEquivalent == 0 || nextEq[nEquivalent - 1] != u) {
                    nextEq[nEquivalent++] = u;
                }
                nextEq[nEquivalent++] = v;
                tmp[v] = (int)prev[v];
                prev[v] = label;
            }
            u = v;
        }
        if (nEquivalent < nextEq.length) {
            nextEq[nEquivalent] = -1;
        }
        return nRanks;
    }

    void sortBy(int[] vs, int lo, int len, long[] curr, long[] prev) {
        if (len < 42) {
            InvariantRanker.insertionSortBy(vs, lo, len, curr, prev);
            return;
        }
        int split = len / 2;
        this.sortBy(vs, lo, split, curr, prev);
        this.sortBy(vs, lo + split, len - split, curr, prev);
        if (!InvariantRanker.less(vs[lo + split], vs[lo + split - 1], curr, prev)) {
            return;
        }
        this.merge(vs, lo, split, len, curr, prev);
    }

    private void merge(int[] vs, int lo, int split, int len, long[] curr, long[] prev) {
        System.arraycopy(vs, lo, this.aux, lo, len);
        int i = lo;
        int j = lo + split;
        int iMax = lo + split;
        int jMax = lo + len;
        int end = lo + len;
        for (int k = lo; k < end; ++k) {
            vs[k] = i == iMax ? this.aux[j++] : (j == jMax ? this.aux[i++] : (InvariantRanker.less(this.aux[i], this.aux[j], curr, prev) ? this.aux[i++] : this.aux[j++]));
        }
    }

    static void insertionSortBy(int[] vs, int lo, int len, long[] curr, long[] prev) {
        int hi = lo + len;
        for (int j = lo + 1; j < hi; ++j) {
            int v = vs[j];
            int i = j - 1;
            while (i >= lo && InvariantRanker.less(v, vs[i], curr, prev)) {
                vs[i + 1] = vs[i--];
            }
            vs[i + 1] = v;
        }
    }

    static boolean less(int i, int j, long[] curr, long[] prev) {
        return prev[i] < prev[j] || prev[i] == prev[j] && curr[i] < curr[j];
    }
}

