/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.isomorphism.AtomMapFilter;
import org.openscience.cdk.isomorphism.ComponentFilter;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.QueryStereoFilter;
import org.openscience.cdk.isomorphism.StereoMatch;
import org.openscience.cdk.isomorphism.VentoFoggia;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

public abstract class Pattern {
    private boolean hasStereo;
    private boolean hasQueryStereo;
    private boolean hasCompGrp;
    private boolean hasRxnMap;

    void determineFilters(IAtomContainer query2) {
        this.hasStereo = query2.stereoElements().iterator().hasNext();
        this.hasCompGrp = query2.getProperty("COMPONENT.GROUPING") != null;
        for (IAtom atom : query2.atoms()) {
            Integer compId = (Integer)atom.getProperty("cdk:ReactionGroup");
            Integer mapIdx = (Integer)atom.getProperty("cdk:AtomAtomMapping");
            if (mapIdx != null && mapIdx != 0) {
                this.hasRxnMap = true;
            }
            if (compId != null && compId != 0) {
                this.hasCompGrp = true;
            }
            if (atom instanceof IQueryAtom) {
                this.hasQueryStereo = true;
            }
            if (!this.hasRxnMap || !this.hasCompGrp || !this.hasQueryStereo) continue;
            break;
        }
    }

    Mappings filter(Mappings mappings, IAtomContainer query2, IAtomContainer target) {
        if (this.hasStereo) {
            Mappings mappings2 = mappings = this.hasQueryStereo ? mappings.filter(new QueryStereoFilter(query2, target)) : mappings.filter(new StereoMatch(query2, target));
        }
        if (this.hasCompGrp) {
            mappings = mappings.filter(new ComponentFilter(query2, target));
        }
        if (this.hasRxnMap) {
            mappings = mappings.filter(new AtomMapFilter(query2, target));
        }
        return mappings;
    }

    public abstract int[] match(IAtomContainer var1);

    public boolean matches(IAtomContainer target) {
        return this.match(target).length > 0;
    }

    public final boolean matches(IReaction target) {
        return this.matches(ReactionManipulator.toMolecule(target));
    }

    public abstract Mappings matchAll(IAtomContainer var1);

    public final Mappings matchAll(IReaction target) {
        return this.matchAll(ReactionManipulator.toMolecule(target));
    }

    public static Pattern findSubstructure(IAtomContainer query2) {
        return VentoFoggia.findSubstructure(query2);
    }

    public static Pattern findIdentical(IAtomContainer query2) {
        return VentoFoggia.findIdentical(query2);
    }
}

