/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.JaiI18N;
import it.geosolutions.jaiext.scale.Scale2PropertyGenerator;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class Scale2Descriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(Scale2Descriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "Scale2"}, {"LocalName", "Scale2"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", JaiI18N.getString("ScaleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ScaleDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("ScaleDescriptor1")}, {"arg1Desc", JaiI18N.getString("ScaleDescriptor2")}, {"arg2Desc", JaiI18N.getString("ScaleDescriptor3")}, {"arg3Desc", JaiI18N.getString("ScaleDescriptor4")}, {"arg4Desc", JaiI18N.getString("ScaleDescriptor5")}, {"arg5Desc", JaiI18N.getString("ScaleDescriptor6")}, {"arg6Desc", JaiI18N.getString("ScaleDescriptor7")}, {"arg7Desc", JaiI18N.getString("ScaleDescriptor8")}, {"arg8Desc", JaiI18N.getString("ScaleDescriptor9")}};
    private static final Class[] paramClasses = new Class[]{Double.class, Double.class, Double.class, Double.class, Interpolation.class, ROI.class, Boolean.class, Range.class, double[].class};
    private static final String[] paramNames = new String[]{"xScale", "yScale", "xTrans", "yTrans", "interpolation", "ROI", "useRoiAccessor", "nodata", "backgroundValues"};
    private static final Object[] paramDefaults = new Object[]{new Double(1.0), new Double(1.0), new Double(0.0), new Double(0.0), Interpolation.getInstance(0), null, false, null, null};

    public Scale2Descriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    @Override
    public boolean isRenderableSupported() {
        return false;
    }

    @Override
    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new Scale2PropertyGenerator()};
        return pg;
    }

    @Override
    protected boolean validateParameters(ParameterBlock args, StringBuffer msg) {
        if (!super.validateParameters(args, msg)) {
            return false;
        }
        double xScale = args.getDoubleParameter(0);
        double yScale = args.getDoubleParameter(1);
        ROI roi = null;
        if (args.getNumParameters() > 5 && args.getObjectParameter(5) != null) {
            roi = (ROI)args.getObjectParameter(5);
        }
        if ((xScale <= 0.0 || yScale <= 0.0) && roi == null) {
            msg.append(this.getName() + " " + JaiI18N.getString("ScaleDescriptor6"));
            return false;
        }
        return true;
    }

    @Override
    public Number getParamMinValue(int index) {
        if (index == 0 || index == 1) {
            return new Double(0.0);
        }
        if (index == 2 || index == 3) {
            return new Double(-1.7976931348623157E308);
        }
        if (index == 4 || index == 5 || index == 6 || index == 7 || index == 8) {
            return null;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static RenderedOp create(RenderedImage source0, Double xScale, Double yScale, Double xTrans, Double yTrans, Interpolation interpolation, ROI roi, Boolean useRoiAccessor, Range nodata, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Scale2", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("xScale", xScale);
        pb.setParameter("yScale", yScale);
        pb.setParameter("xTrans", xTrans);
        pb.setParameter("yTrans", yTrans);
        pb.setParameter("interpolation", interpolation);
        pb.setParameter("nodata", nodata);
        if (roi != null) {
            pb.setParameter("ROI", roi);
        }
        if (backgroundValues != null) {
            pb.setParameter("backgroundValues", backgroundValues);
        }
        pb.setParameter("useRoiAccessor", useRoiAccessor);
        return JAI.create("Scale2", pb, hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, Double xScale, Double yScale, Double xTrans, Double yTrans, Interpolation interpolation, ROI roi, Range nodata, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Scale2", "renderable");
        pb.setSource("source0", source0);
        pb.setParameter("xScale", xScale);
        pb.setParameter("yScale", yScale);
        pb.setParameter("xTrans", xTrans);
        pb.setParameter("yTrans", yTrans);
        pb.setParameter("interpolation", interpolation);
        pb.setParameter("nodata", nodata);
        if (roi != null) {
            pb.setParameter("ROI", roi);
        }
        if (backgroundValues != null) {
            pb.setParameter("backgroundValues", backgroundValues);
        }
        return JAI.createRenderable("Scale2", pb, hints);
    }
}

