/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.trees;

import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropMaxDegTree
extends Propagator<UndirectedGraphVar> {
    protected int n;
    protected int[] dMax;
    private final int[] counter;
    private final BitSet oneNode;
    private int[] list;

    public PropMaxDegTree(UndirectedGraphVar g2, int[] maxDegrees) {
        super((Variable[])new UndirectedGraphVar[]{g2}, (Priority)PropagatorPriority.LINEAR, false);
        this.n = maxDegrees.length;
        this.oneNode = new BitSet(this.n);
        this.counter = new int[this.n];
        this.dMax = maxDegrees;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_EDGE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.preprocessOneNodes();
        UndirectedGraphVar g2 = ((UndirectedGraphVar[])this.vars)[0];
        if (this.oneNode.cardinality() < this.n) {
            for (int i = 0; i < this.n; ++i) {
                ISet nei = g2.getPotentialNeighborsOf(i);
                if (!this.oneNode.get(i)) continue;
                ISetIterator iSetIterator = nei.iterator();
                while (iSetIterator.hasNext()) {
                    int j = (Integer)iSetIterator.next();
                    if (!this.oneNode.get(j) || g2.getMandatoryNeighborsOf(i).contains(j)) continue;
                    g2.removeEdge(i, j, this);
                }
            }
        }
    }

    private void preprocessOneNodes() throws ContradictionException {
        this.oneNode.clear();
        for (int i = 0; i < this.n; ++i) {
            this.counter[i] = 0;
        }
        UndirectedGraphVar g2 = ((UndirectedGraphVar[])this.vars)[0];
        int[] maxDegree = this.dMax;
        if (this.list == null) {
            this.list = new int[this.n];
        }
        int first = 0;
        int last = 0;
        for (int i = 0; i < this.n; ++i) {
            if (maxDegree[i] != 1) continue;
            this.list[last++] = i;
            this.oneNode.set(i);
        }
        while (first < last) {
            int k = this.list[first++];
            ISet nei = g2.getMandatoryNeighborsOf(k);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int s2 = (Integer)iSetIterator.next();
                if (this.oneNode.get(s2)) continue;
                int n = s2;
                this.counter[n] = this.counter[n] + 1;
                if (this.counter[s2] > maxDegree[s2]) {
                    this.fails();
                    continue;
                }
                if (this.counter[s2] != maxDegree[s2] - 1) continue;
                this.oneNode.set(s2);
                this.list[last++] = s2;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

