/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.sort.ArraySort;

public class DisjunctiveTaskIntervalFilter
extends CumulFilter {
    private final TIntArrayList list = new TIntArrayList();

    public DisjunctiveTaskIntervalFilter(int nbMaxTasks) {
        super(nbMaxTasks);
    }

    @Override
    public void filter(IntVar[] s2, IntVar[] d2, IntVar[] e2, IntVar[] h2, IntVar capa, ISet tasks, Propagator<IntVar> aCause) throws ContradictionException {
        capa.updateUpperBound(1, aCause);
        this.list.reset();
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int t = tIter.nextInt();
            if (d2[t].getLB() <= 0 || h2[t].getLB() <= 0) continue;
            this.list.add(t);
        }
        int[] tsks = this.list.toArray();
        ArraySort sort = new ArraySort(tsks.length, false, true);
        sort.sort(tsks, tsks.length, (i1, i2) -> s2[i1].getLB() - s2[i2].getLB());
        for (int x = 0; x < tsks.length; ++x) {
            int task1 = tsks[x];
            for (int y = 0; y < tsks.length; ++y) {
                if (x == y) continue;
                int task2 = tsks[y];
                int t1 = s2[task1].getLB();
                int t2 = e2[task2].getUB();
                if (e2[task1].getLB() > s2[task2].getUB()) {
                    s2[task1].updateLowerBound(e2[task2].getLB(), aCause);
                    e2[task2].updateUpperBound(s2[task1].getUB(), aCause);
                    continue;
                }
                if (t1 >= t2 || t1 >= e2[task2].getLB() && t2 <= s2[task1].getUB()) continue;
                int W = 0;
                for (int task3 : tsks) {
                    if (task3 == task1 || task3 == task2) continue;
                    if (s2[task3].getLB() >= t2) break;
                    int pB = d2[task3].getLB() * h2[task3].getLB();
                    int pbt1 = Math.max(0, pB - Math.max(0, t1 - s2[task3].getLB()));
                    int pbt2 = Math.max(0, pB - Math.max(0, e2[task3].getUB() - t2));
                    int pbt = Math.min(pbt1, pbt2);
                    W += Math.min(t2 - t1, pbt);
                }
                if (W + d2[task1].getLB() + d2[task2].getLB() <= t2 - t1) continue;
                s2[task1].updateLowerBound(e2[task2].getLB(), aCause);
                e2[task2].updateUpperBound(s2[task1].getUB(), aCause);
            }
        }
    }
}

