/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSetIntValuesUnion
extends Propagator<Variable> {
    private final IntVar[] X;
    private final SetVar values;

    public PropSetIntValuesUnion(IntVar[] X2, SetVar values) {
        super(ArrayUtils.append(X2, {values}));
        this.X = X2;
        this.values = values;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iter = this.values.getUB().iterator();
        while (iter.hasNext()) {
            int v = iter.nextInt();
            int support = -1;
            for (int i = 0; i < this.X.length; ++i) {
                if (!this.X[i].contains(v)) continue;
                if (support == -1) {
                    support = i;
                    continue;
                }
                support = -2;
                break;
            }
            if (support == -1) {
                this.values.remove(v, this);
                continue;
            }
            if (support == -2 || !this.values.getLB().contains(v)) continue;
            this.X[support].instantiateTo(v, this);
        }
        for (int i = 0; i < this.X.length; ++i) {
            if (this.X[i].isInstantiated()) {
                this.values.force(this.X[i].getValue(), this);
                continue;
            }
            int v = this.X[i].getLB();
            while (v <= this.X[i].getUB()) {
                if (!this.values.getUB().contains(v)) {
                    this.X[i].removeValue(v, this);
                }
                v = this.X[i].nextValue(v);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        ISetIterator iter = this.values.getLB().iterator();
        while (iter.hasNext()) {
            int v = iter.nextInt();
            int support = -1;
            for (int i = 0; i < this.X.length; ++i) {
                if (!this.X[i].contains(v)) continue;
                if (support == -1) {
                    support = i;
                    continue;
                }
                support = -2;
                break;
            }
            if (support != -1) continue;
            return ESat.FALSE;
        }
        for (IntVar x : this.X) {
            if (!x.isInstantiated() || this.values.getUB().contains(x.getValue())) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

