/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row;

import java.util.Arrays;
import org.ejml.EjmlParameters;
import org.ejml.LinearSolverSafe;
import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.BMatrixRMaj;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.decomposition.lu.LUDecompositionAlt_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.dense.row.linsol.lu.LinearSolverLu_DDRM;
import org.ejml.dense.row.misc.ImplCommonOps_DDMA;
import org.ejml.dense.row.misc.ImplCommonOps_DDRM;
import org.ejml.dense.row.misc.RrefGaussJordanRowPivot_DDRM;
import org.ejml.dense.row.misc.TransposeAlgs_DDRM;
import org.ejml.dense.row.misc.UnrolledDeterminantFromMinor_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import org.ejml.dense.row.mult.MatrixMatrixMult_DDRM;
import org.ejml.dense.row.mult.MatrixMultProduct_DDRM;
import org.ejml.dense.row.mult.MatrixVectorMult_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class CommonOps_DDRM {
    public static void mult(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numCols == 1) {
            MatrixVectorMult_DDRM.mult(a2, b2, c2);
        } else if (b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.mult_reorder(a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.mult_small(a2, b2, c2);
        }
    }

    public static void mult(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.mult_reorder(alpha, a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.mult_small(alpha, a2, b2, c2);
        }
    }

    public static void multTransA(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numCols == 1) {
            if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multTransA_reorder(a2, b2, c2);
            } else {
                MatrixVectorMult_DDRM.multTransA_small(a2, b2, c2);
            }
        } else if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransA_reorder(a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multTransA_small(a2, b2, c2);
        }
    }

    public static void multTransA(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransA_reorder(alpha, a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multTransA_small(alpha, a2, b2, c2);
        }
    }

    public static void multTransB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numRows == 1) {
            MatrixVectorMult_DDRM.mult(a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multTransB(a2, b2, c2);
        }
    }

    public static void multTransB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        MatrixMatrixMult_DDRM.multTransB(alpha, a2, b2, c2);
    }

    public static void multTransAB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numRows == 1) {
            if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multTransA_reorder(a2, b2, c2);
            } else {
                MatrixVectorMult_DDRM.multTransA_small(a2, b2, c2);
            }
        } else if (a2.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransAB_aux(a2, b2, c2, null);
        } else {
            MatrixMatrixMult_DDRM.multTransAB(a2, b2, c2);
        }
    }

    public static void multTransAB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multTransAB_aux(alpha, a2, b2, c2, null);
        } else {
            MatrixMatrixMult_DDRM.multTransAB(alpha, a2, b2, c2);
        }
    }

    public static double dot(DMatrixD1 a2, DMatrixD1 b2) {
        if (!MatrixFeatures_DDRM.isVector(a2) || !MatrixFeatures_DDRM.isVector(b2)) {
            throw new RuntimeException("Both inputs must be vectors");
        }
        return VectorVectorMult_DDRM.innerProd(a2, b2);
    }

    public static void multInner(DMatrix1Row a2, DMatrix1Row c2) {
        if (a2.numCols != c2.numCols || a2.numCols != c2.numRows) {
            throw new MatrixDimensionException("Rows and columns of 'c' must be the same as the columns in 'a'");
        }
        if (a2.numCols >= EjmlParameters.MULT_INNER_SWITCH) {
            MatrixMultProduct_DDRM.inner_small(a2, c2);
        } else {
            MatrixMultProduct_DDRM.inner_reorder(a2, c2);
        }
    }

    public static void multOuter(DMatrix1Row a2, DMatrix1Row c2) {
        if (a2.numRows != c2.numCols || a2.numRows != c2.numRows) {
            throw new MatrixDimensionException("Rows and columns of 'c' must be the same as the rows in 'a'");
        }
        MatrixMultProduct_DDRM.outer(a2, c2);
    }

    public static void multAdd(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numCols == 1) {
            MatrixVectorMult_DDRM.multAdd(a2, b2, c2);
        } else if (b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAdd_reorder(a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multAdd_small(a2, b2, c2);
        }
    }

    public static void multAdd(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAdd_reorder(alpha, a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multAdd_small(alpha, a2, b2, c2);
        }
    }

    public static void multAddTransA(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numCols == 1) {
            if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multAddTransA_reorder(a2, b2, c2);
            } else {
                MatrixVectorMult_DDRM.multAddTransA_small(a2, b2, c2);
            }
        } else if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransA_reorder(a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multAddTransA_small(a2, b2, c2);
        }
    }

    public static void multAddTransA(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || b2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransA_reorder(alpha, a2, b2, c2);
        } else {
            MatrixMatrixMult_DDRM.multAddTransA_small(alpha, a2, b2, c2);
        }
    }

    public static void multAddTransB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        MatrixMatrixMult_DDRM.multAddTransB(a2, b2, c2);
    }

    public static void multAddTransB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        MatrixMatrixMult_DDRM.multAddTransB(alpha, a2, b2, c2);
    }

    public static void multAddTransAB(DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (b2.numRows == 1) {
            if (a2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult_DDRM.multAddTransA_reorder(a2, b2, c2);
            } else {
                MatrixVectorMult_DDRM.multAddTransA_small(a2, b2, c2);
            }
        } else if (a2.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransAB_aux(a2, b2, c2, null);
        } else {
            MatrixMatrixMult_DDRM.multAddTransAB(a2, b2, c2);
        }
    }

    public static void multAddTransAB(double alpha, DMatrix1Row a2, DMatrix1Row b2, DMatrix1Row c2) {
        if (a2.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult_DDRM.multAddTransAB_aux(alpha, a2, b2, c2, null);
        } else {
            MatrixMatrixMult_DDRM.multAddTransAB(alpha, a2, b2, c2);
        }
    }

    public static boolean solve(DMatrixRMaj a2, DMatrixRMaj b2, DMatrixRMaj x) {
        LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.general(a2.numRows, a2.numCols);
        if (!(solver = new LinearSolverSafe<DMatrixRMaj>(solver)).setA(a2)) {
            return false;
        }
        solver.solve(b2, x);
        return true;
    }

    public static void transpose(DMatrixRMaj mat) {
        if (mat.numCols == mat.numRows) {
            TransposeAlgs_DDRM.square(mat);
        } else {
            DMatrixRMaj b2 = new DMatrixRMaj(mat.numCols, mat.numRows);
            CommonOps_DDRM.transpose(mat, b2);
            mat.set(b2);
        }
    }

    public static DMatrixRMaj transpose(DMatrixRMaj A2, DMatrixRMaj A_tran) {
        if (A_tran == null) {
            A_tran = new DMatrixRMaj(A2.numCols, A2.numRows);
        } else if (A2.numRows != A_tran.numCols || A2.numCols != A_tran.numRows) {
            throw new MatrixDimensionException("Incompatible matrix dimensions");
        }
        if (A2.numRows > EjmlParameters.TRANSPOSE_SWITCH && A2.numCols > EjmlParameters.TRANSPOSE_SWITCH) {
            TransposeAlgs_DDRM.block(A2, A_tran, EjmlParameters.BLOCK_WIDTH);
        } else {
            TransposeAlgs_DDRM.standard(A2, A_tran);
        }
        return A_tran;
    }

    public static double trace(DMatrix1Row a2) {
        int N = Math.min(a2.numRows, a2.numCols);
        double sum = 0.0;
        int index = 0;
        for (int i = 0; i < N; ++i) {
            sum += a2.get(index);
            index += 1 + a2.numCols;
        }
        return sum;
    }

    public static double det(DMatrixRMaj mat) {
        int numRow;
        int numCol = mat.getNumCols();
        if (numCol != (numRow = mat.getNumRows())) {
            throw new MatrixDimensionException("Must be a square matrix.");
        }
        if (numCol <= 6) {
            if (numCol >= 2) {
                return UnrolledDeterminantFromMinor_DDRM.det(mat);
            }
            return mat.get(0);
        }
        LUDecompositionAlt_DDRM alg = new LUDecompositionAlt_DDRM();
        if (alg.inputModified()) {
            mat = mat.copy();
        }
        if (!alg.decompose(mat)) {
            return 0.0;
        }
        return alg.computeDeterminant().real;
    }

    public static boolean invert(DMatrixRMaj mat) {
        if (mat.numCols <= 5) {
            if (mat.numCols != mat.numRows) {
                throw new MatrixDimensionException("Must be a square matrix.");
            }
            if (mat.numCols >= 2) {
                UnrolledInverseFromMinor_DDRM.inv(mat, mat);
            } else {
                mat.set(0, 1.0 / mat.get(0));
            }
        } else {
            LUDecompositionAlt_DDRM alg = new LUDecompositionAlt_DDRM();
            LinearSolverLu_DDRM solver = new LinearSolverLu_DDRM(alg);
            if (solver.setA(mat)) {
                solver.invert(mat);
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean invert(DMatrixRMaj mat, DMatrixRMaj result) {
        if (mat.numCols <= 5) {
            if (mat.numCols != mat.numRows) {
                throw new MatrixDimensionException("Must be a square matrix.");
            }
            if (result.numCols >= 2) {
                UnrolledInverseFromMinor_DDRM.inv(mat, result);
            } else {
                result.set(0, 1.0 / mat.get(0));
            }
        } else {
            LUDecompositionAlt_DDRM alg = new LUDecompositionAlt_DDRM();
            LinearSolverLu_DDRM solver = new LinearSolverLu_DDRM(alg);
            if (solver.modifiesA()) {
                mat = mat.copy();
            }
            if (!solver.setA(mat)) {
                return false;
            }
            solver.invert(result);
        }
        return true;
    }

    public static void pinv(DMatrixRMaj A2, DMatrixRMaj invA) {
        LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.pseudoInverse(true);
        if (solver.modifiesA()) {
            A2 = A2.copy();
        }
        if (!solver.setA(A2)) {
            throw new IllegalArgumentException("Invert failed, maybe a bug?");
        }
        solver.invert(invA);
    }

    public static DMatrixRMaj[] columnsToVector(DMatrixRMaj A2, DMatrixRMaj[] v) {
        DMatrixRMaj[] ret = v == null || v.length < A2.numCols ? new DMatrixRMaj[A2.numCols] : v;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null) {
                ret[i] = new DMatrixRMaj(A2.numRows, 1);
            } else {
                ret[i].reshape(A2.numRows, 1, false);
            }
            DMatrixRMaj u = ret[i];
            for (int j = 0; j < A2.numRows; ++j) {
                u.set(j, 0, A2.get(j, i));
            }
        }
        return ret;
    }

    public static DMatrixRMaj[] rowsToVector(DMatrixRMaj A2, DMatrixRMaj[] v) {
        DMatrixRMaj[] ret = v == null || v.length < A2.numRows ? new DMatrixRMaj[A2.numRows] : v;
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i] == null) {
                ret[i] = new DMatrixRMaj(A2.numCols, 1);
            } else {
                ret[i].reshape(A2.numCols, 1, false);
            }
            DMatrixRMaj u = ret[i];
            for (int j = 0; j < A2.numCols; ++j) {
                u.set(j, 0, A2.get(i, j));
            }
        }
        return ret;
    }

    public static void setIdentity(DMatrix1Row mat) {
        int width = mat.numRows < mat.numCols ? mat.numRows : mat.numCols;
        Arrays.fill(mat.data, 0, mat.getNumElements(), 0.0);
        int index = 0;
        int i = 0;
        while (i < width) {
            mat.data[index] = 1.0;
            ++i;
            index += mat.numCols + 1;
        }
    }

    public static DMatrixRMaj identity(int width) {
        DMatrixRMaj ret = new DMatrixRMaj(width, width);
        for (int i = 0; i < width; ++i) {
            ret.set(i, i, 1.0);
        }
        return ret;
    }

    public static DMatrixRMaj identity(int numRows, int numCols) {
        DMatrixRMaj ret = new DMatrixRMaj(numRows, numCols);
        int small = numRows < numCols ? numRows : numCols;
        for (int i = 0; i < small; ++i) {
            ret.set(i, i, 1.0);
        }
        return ret;
    }

    public static DMatrixRMaj diag(double ... diagEl) {
        return CommonOps_DDRM.diag(null, diagEl.length, diagEl);
    }

    public static DMatrixRMaj diag(DMatrixRMaj ret, int width, double ... diagEl) {
        if (ret == null) {
            ret = new DMatrixRMaj(width, width);
        } else {
            if (ret.numRows != width || ret.numCols != width) {
                throw new IllegalArgumentException("Unexpected matrix size");
            }
            CommonOps_DDRM.fill(ret, 0.0);
        }
        for (int i = 0; i < width; ++i) {
            ret.unsafe_set(i, i, diagEl[i]);
        }
        return ret;
    }

    public static DMatrixRMaj diagR(int numRows, int numCols, double ... diagEl) {
        DMatrixRMaj ret = new DMatrixRMaj(numRows, numCols);
        int o = Math.min(numRows, numCols);
        for (int i = 0; i < o; ++i) {
            ret.set(i, i, diagEl[i]);
        }
        return ret;
    }

    public static void kron(DMatrixRMaj A2, DMatrixRMaj B, DMatrixRMaj C2) {
        int numColsC = A2.numCols * B.numCols;
        int numRowsC = A2.numRows * B.numRows;
        if (C2.numCols != numColsC || C2.numRows != numRowsC) {
            throw new MatrixDimensionException("C does not have the expected dimensions");
        }
        for (int i = 0; i < A2.numRows; ++i) {
            for (int j = 0; j < A2.numCols; ++j) {
                double a2 = A2.get(i, j);
                for (int rowB = 0; rowB < B.numRows; ++rowB) {
                    for (int colB = 0; colB < B.numCols; ++colB) {
                        double val = a2 * B.get(rowB, colB);
                        C2.set(i * B.numRows + rowB, j * B.numCols + colB, val);
                    }
                }
            }
        }
    }

    public static void extract(DMatrix src, int srcY0, int srcY1, int srcX0, int srcX1, DMatrix dst, int dstY0, int dstX0) {
        if (srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.getNumRows()) {
            throw new MatrixDimensionException("srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.getNumCols()) {
            throw new MatrixDimensionException("srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int w = srcX1 - srcX0;
        int h2 = srcY1 - srcY0;
        if (dstY0 + h2 > dst.getNumRows()) {
            throw new MatrixDimensionException("dst is too small in rows");
        }
        if (dstX0 + w > dst.getNumCols()) {
            throw new MatrixDimensionException("dst is too small in columns");
        }
        if (src instanceof DMatrixRMaj && dst instanceof DMatrixRMaj) {
            ImplCommonOps_DDRM.extract((DMatrixRMaj)src, srcY0, srcX0, (DMatrixRMaj)dst, dstY0, dstX0, h2, w);
        } else {
            ImplCommonOps_DDMA.extract(src, srcY0, srcX0, dst, dstY0, dstX0, h2, w);
        }
    }

    public static DMatrixRMaj extract(DMatrixRMaj src, int srcY0, int srcY1, int srcX0, int srcX1) {
        if (srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows) {
            throw new MatrixDimensionException("srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols) {
            throw new MatrixDimensionException("srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int w = srcX1 - srcX0;
        int h2 = srcY1 - srcY0;
        DMatrixRMaj dst = new DMatrixRMaj(h2, w);
        ImplCommonOps_DDRM.extract(src, srcY0, srcX0, dst, 0, 0, h2, w);
        return dst;
    }

    public static void extract(DMatrixRMaj src, int[] rows, int rowsSize, int[] cols, int colsSize, DMatrixRMaj dst) {
        if (rowsSize != dst.numRows || colsSize != dst.numCols) {
            throw new MatrixDimensionException("Unexpected number of rows and/or columns in dst matrix");
        }
        int indexDst = 0;
        for (int i = 0; i < rowsSize; ++i) {
            int indexSrcRow = src.numCols * rows[i];
            for (int j = 0; j < colsSize; ++j) {
                dst.data[indexDst++] = src.data[indexSrcRow + cols[j]];
            }
        }
    }

    public static void extract(DMatrixRMaj src, int[] indexes, int length, DMatrixRMaj dst) {
        if (!MatrixFeatures_DDRM.isVector(dst)) {
            throw new MatrixDimensionException("Dst must be a vector");
        }
        if (length != dst.getNumElements()) {
            throw new MatrixDimensionException("Unexpected number of elements in dst vector");
        }
        for (int i = 0; i < length; ++i) {
            dst.data[i] = src.data[indexes[i]];
        }
    }

    public static void insert(DMatrixRMaj src, DMatrixRMaj dst, int[] rows, int rowsSize, int[] cols, int colsSize) {
        if (rowsSize != src.numRows || colsSize != src.numCols) {
            throw new MatrixDimensionException("Unexpected number of rows and/or columns in dst matrix");
        }
        int indexSrc = 0;
        for (int i = 0; i < rowsSize; ++i) {
            int indexDstRow = dst.numCols * rows[i];
            for (int j = 0; j < colsSize; ++j) {
                dst.data[indexDstRow + cols[j]] = src.data[indexSrc++];
            }
        }
    }

    public static void extractDiag(DMatrixRMaj src, DMatrixRMaj dst) {
        int N = Math.min(src.numRows, src.numCols);
        if (!MatrixFeatures_DDRM.isVector(dst) || dst.numCols * dst.numCols != N) {
            dst.reshape(N, 1);
        }
        for (int i = 0; i < N; ++i) {
            dst.set(i, src.unsafe_get(i, i));
        }
    }

    public static DMatrixRMaj extractRow(DMatrixRMaj a2, int row, DMatrixRMaj out) {
        if (out == null) {
            out = new DMatrixRMaj(1, a2.numCols);
        } else if (!MatrixFeatures_DDRM.isVector(out) || out.getNumElements() != a2.numCols) {
            throw new MatrixDimensionException("Output must be a vector of length " + a2.numCols);
        }
        System.arraycopy(a2.data, a2.getIndex(row, 0), out.data, 0, a2.numCols);
        return out;
    }

    public static DMatrixRMaj extractColumn(DMatrixRMaj a2, int column, DMatrixRMaj out) {
        if (out == null) {
            out = new DMatrixRMaj(a2.numRows, 1);
        } else if (!MatrixFeatures_DDRM.isVector(out) || out.getNumElements() != a2.numRows) {
            throw new MatrixDimensionException("Output must be a vector of length " + a2.numRows);
        }
        int index = column;
        int i = 0;
        while (i < a2.numRows) {
            out.data[i] = a2.data[index];
            ++i;
            index += a2.numCols;
        }
        return out;
    }

    public static void insert(DMatrix src, DMatrix dest, int destY0, int destX0) {
        CommonOps_DDRM.extract(src, 0, src.getNumRows(), 0, src.getNumCols(), dest, destY0, destX0);
    }

    public static double elementMax(DMatrixD1 a2) {
        int size = a2.getNumElements();
        double max = a2.get(0);
        for (int i = 1; i < size; ++i) {
            double val = a2.get(i);
            if (!(val >= max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrixD1 a2) {
        int size = a2.getNumElements();
        double max = 0.0;
        for (int i = 0; i < size; ++i) {
            double val = Math.abs(a2.get(i));
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static double elementMin(DMatrixD1 a2) {
        int size = a2.getNumElements();
        double min2 = a2.get(0);
        for (int i = 1; i < size; ++i) {
            double val = a2.get(i);
            if (!(val < min2)) continue;
            min2 = val;
        }
        return min2;
    }

    public static double elementMinAbs(DMatrixD1 a2) {
        int size = a2.getNumElements();
        double min2 = Double.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            double val = Math.abs(a2.get(i));
            if (!(val < min2)) continue;
            min2 = val;
        }
        return min2;
    }

    public static void elementMult(DMatrixD1 a2, DMatrixD1 b2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            a2.times(i, b2.get(i));
        }
    }

    public static void elementMult(DMatrixD1 a2, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows || a2.numRows != c2.numRows || a2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.set(i, a2.get(i) * b2.get(i));
        }
    }

    public static void elementDiv(DMatrixD1 a2, DMatrixD1 b2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            a2.div(i, b2.get(i));
        }
    }

    public static void elementDiv(DMatrixD1 a2, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows || a2.numRows != c2.numRows || a2.numCols != c2.numCols) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.set(i, a2.get(i) / b2.get(i));
        }
    }

    public static double elementSum(DMatrixD1 mat) {
        double total = 0.0;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += mat.get(i);
        }
        return total;
    }

    public static double elementSumAbs(DMatrixD1 mat) {
        double total = 0.0;
        int size = mat.getNumElements();
        for (int i = 0; i < size; ++i) {
            total += Math.abs(mat.get(i));
        }
        return total;
    }

    public static void elementPower(DMatrixD1 A2, DMatrixD1 B, DMatrixD1 C2) {
        if (A2.numRows != B.numRows || A2.numRows != C2.numRows || A2.numCols != B.numCols || A2.numCols != C2.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            C2.data[i] = Math.pow(A2.data[i], B.data[i]);
        }
    }

    public static void elementPower(double a2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows != C2.numRows || B.numCols != C2.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = B.getNumElements();
        for (int i = 0; i < size; ++i) {
            C2.data[i] = Math.pow(a2, B.data[i]);
        }
    }

    public static void elementPower(DMatrixD1 A2, double b2, DMatrixD1 C2) {
        if (A2.numRows != C2.numRows || A2.numCols != C2.numCols) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            C2.data[i] = Math.pow(A2.data[i], b2);
        }
    }

    public static void elementLog(DMatrixD1 A2, DMatrixD1 C2) {
        if (A2.numCols != C2.numCols || A2.numRows != C2.numRows) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            C2.data[i] = Math.log(A2.data[i]);
        }
    }

    public static void elementExp(DMatrixD1 A2, DMatrixD1 C2) {
        if (A2.numCols != C2.numCols || A2.numRows != C2.numRows) {
            throw new MatrixDimensionException("All matrices must be the same shape");
        }
        int size = A2.getNumElements();
        for (int i = 0; i < size; ++i) {
            C2.data[i] = Math.exp(A2.data[i]);
        }
    }

    public static DMatrixRMaj sumRows(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            double total = 0.0;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                total += input.data[index];
            }
            output.set(row, total);
        }
        return output;
    }

    public static DMatrixRMaj minRows(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            double min2 = Double.MAX_VALUE;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                double v = input.data[index];
                if (!(v < min2)) continue;
                min2 = v;
            }
            output.set(row, min2);
        }
        return output;
    }

    public static DMatrixRMaj maxRows(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(input.numRows, 1);
        } else {
            output.reshape(input.numRows, 1);
        }
        for (int row = 0; row < input.numRows; ++row) {
            double max = -1.7976931348623157E308;
            int end = (row + 1) * input.numCols;
            for (int index = row * input.numCols; index < end; ++index) {
                double v = input.data[index];
                if (!(v > max)) continue;
                max = v;
            }
            output.set(row, max);
        }
        return output;
    }

    public static DMatrixRMaj sumCols(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            double total = 0.0;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                total += input.data[index];
            }
            output.set(cols, total);
        }
        return output;
    }

    public static DMatrixRMaj minCols(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            double minimum = Double.MAX_VALUE;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                double v = input.data[index];
                if (!(v < minimum)) continue;
                minimum = v;
            }
            output.set(cols, minimum);
        }
        return output;
    }

    public static DMatrixRMaj maxCols(DMatrixRMaj input, DMatrixRMaj output) {
        if (output == null) {
            output = new DMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int cols = 0; cols < input.numCols; ++cols) {
            int index;
            double maximum = -1.7976931348623157E308;
            int end = index + input.numCols * input.numRows;
            for (index = cols; index < end; index += input.numCols) {
                double v = input.data[index];
                if (!(v > maximum)) continue;
                maximum = v;
            }
            output.set(cols, maximum);
        }
        return output;
    }

    public static void addEquals(DMatrixD1 a2, DMatrixD1 b2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            a2.plus(i, b2.get(i));
        }
    }

    public static void addEquals(DMatrixD1 a2, double beta, DMatrixD1 b2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            a2.plus(i, beta * b2.get(i));
        }
    }

    public static void add(DMatrixD1 a2, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows || a2.numCols != c2.numCols || a2.numRows != c2.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.set(i, a2.get(i) + b2.get(i));
        }
    }

    public static void add(DMatrixD1 a2, double beta, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows || a2.numCols != c2.numCols || a2.numRows != c2.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.set(i, a2.get(i) + beta * b2.get(i));
        }
    }

    public static void add(double alpha, DMatrixD1 a2, double beta, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows || a2.numCols != c2.numCols || a2.numRows != c2.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.set(i, alpha * a2.get(i) + beta * b2.get(i));
        }
    }

    public static void add(double alpha, DMatrixD1 a2, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows || a2.numCols != c2.numCols || a2.numRows != c2.numRows) {
            throw new MatrixDimensionException("The matrices are not all the same dimension.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.set(i, alpha * a2.get(i) + b2.get(i));
        }
    }

    public static void add(DMatrixD1 a2, double val) {
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            a2.plus(i, val);
        }
    }

    public static void add(DMatrixD1 a2, double val, DMatrixD1 c2) {
        if (a2.numRows != c2.numRows || a2.numCols != c2.numCols) {
            throw new MatrixDimensionException("Dimensions of a and c do not match.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.data[i] = a2.data[i] + val;
        }
    }

    public static void subtract(DMatrixD1 a2, double val, DMatrixD1 c2) {
        if (a2.numRows != c2.numRows || a2.numCols != c2.numCols) {
            throw new MatrixDimensionException("Dimensions of a and c do not match.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.data[i] = a2.data[i] - val;
        }
    }

    public static void subtract(double val, DMatrixD1 a2, DMatrixD1 c2) {
        if (a2.numRows != c2.numRows || a2.numCols != c2.numCols) {
            throw new MatrixDimensionException("Dimensions of a and c do not match.");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.data[i] = val - a2.data[i];
        }
    }

    public static void subtractEquals(DMatrixD1 a2, DMatrixD1 b2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            int n = i;
            a2.data[n] = a2.data[n] - b2.data[i];
        }
    }

    public static void subtract(DMatrixD1 a2, DMatrixD1 b2, DMatrixD1 c2) {
        if (a2.numCols != b2.numCols || a2.numRows != b2.numRows) {
            throw new MatrixDimensionException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int length = a2.getNumElements();
        for (int i = 0; i < length; ++i) {
            c2.data[i] = a2.data[i] - b2.data[i];
        }
    }

    public static void scale(double alpha, DMatrixD1 a2) {
        int size = a2.getNumElements();
        int i = 0;
        while (i < size) {
            int n = i++;
            a2.data[n] = a2.data[n] * alpha;
        }
    }

    public static void scale(double alpha, DMatrixD1 a2, DMatrixD1 b2) {
        if (a2.numRows != b2.numRows || a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("Matrices must have the same shape");
        }
        int size = a2.getNumElements();
        for (int i = 0; i < size; ++i) {
            b2.data[i] = a2.data[i] * alpha;
        }
    }

    public static void divide(double alpha, DMatrixD1 a2) {
        int size = a2.getNumElements();
        for (int i = 0; i < size; ++i) {
            a2.data[i] = alpha / a2.data[i];
        }
    }

    public static void divide(DMatrixD1 a2, double alpha) {
        int size = a2.getNumElements();
        int i = 0;
        while (i < size) {
            int n = i++;
            a2.data[n] = a2.data[n] / alpha;
        }
    }

    public static void divide(double alpha, DMatrixD1 a2, DMatrixD1 b2) {
        if (a2.numRows != b2.numRows || a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("Matrices must have the same shape");
        }
        int size = a2.getNumElements();
        for (int i = 0; i < size; ++i) {
            b2.data[i] = alpha / a2.data[i];
        }
    }

    public static void divide(DMatrixD1 a2, double alpha, DMatrixD1 b2) {
        if (a2.numRows != b2.numRows || a2.numCols != b2.numCols) {
            throw new MatrixDimensionException("Matrices must have the same shape");
        }
        int size = a2.getNumElements();
        for (int i = 0; i < size; ++i) {
            b2.data[i] = a2.data[i] / alpha;
        }
    }

    public static void changeSign(DMatrixD1 a2) {
        int size = a2.getNumElements();
        for (int i = 0; i < size; ++i) {
            a2.data[i] = -a2.data[i];
        }
    }

    public static void changeSign(DMatrixD1 input, DMatrixD1 output) {
        if (input.numRows != output.numRows || input.numCols != output.numCols) {
            throw new MatrixDimensionException("Matrices must have the same shape");
        }
        int size = input.getNumElements();
        for (int i = 0; i < size; ++i) {
            output.data[i] = -input.data[i];
        }
    }

    public static void fill(DMatrixD1 a2, double value) {
        Arrays.fill(a2.data, 0, a2.getNumElements(), value);
    }

    public static DMatrixRMaj rref(DMatrixRMaj A2, int numUnknowns, DMatrixRMaj reduced) {
        if (reduced == null) {
            reduced = new DMatrixRMaj(A2.numRows, A2.numCols);
        } else if (reduced.numCols != A2.numCols || reduced.numRows != A2.numRows) {
            throw new MatrixDimensionException("'re' must have the same shape as the original input matrix");
        }
        if (numUnknowns <= 0) {
            numUnknowns = Math.min(A2.numCols, A2.numRows);
        }
        RrefGaussJordanRowPivot_DDRM alg = new RrefGaussJordanRowPivot_DDRM();
        alg.setTolerance(CommonOps_DDRM.elementMaxAbs(A2) * UtilEjml.EPS * (double)Math.max(A2.numRows, A2.numCols));
        reduced.set(A2);
        alg.reduce(reduced, numUnknowns);
        return reduced;
    }

    public static BMatrixRMaj elementLessThan(DMatrixRMaj A2, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A2.numRows, A2.numCols);
        }
        output.reshape(A2.numRows, A2.numCols);
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A2.data[i] < value;
        }
        return output;
    }

    public static BMatrixRMaj elementLessThanOrEqual(DMatrixRMaj A2, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A2.numRows, A2.numCols);
        }
        output.reshape(A2.numRows, A2.numCols);
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A2.data[i] <= value;
        }
        return output;
    }

    public static BMatrixRMaj elementMoreThan(DMatrixRMaj A2, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A2.numRows, A2.numCols);
        }
        output.reshape(A2.numRows, A2.numCols);
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A2.data[i] > value;
        }
        return output;
    }

    public static BMatrixRMaj elementMoreThanOrEqual(DMatrixRMaj A2, double value, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A2.numRows, A2.numCols);
        }
        output.reshape(A2.numRows, A2.numCols);
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A2.data[i] >= value;
        }
        return output;
    }

    public static BMatrixRMaj elementLessThan(DMatrixRMaj A2, DMatrixRMaj B, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A2.numRows, A2.numCols);
        }
        output.reshape(A2.numRows, A2.numCols);
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A2.data[i] < B.data[i];
        }
        return output;
    }

    public static BMatrixRMaj elementLessThanOrEqual(DMatrixRMaj A2, DMatrixRMaj B, BMatrixRMaj output) {
        if (output == null) {
            output = new BMatrixRMaj(A2.numRows, A2.numCols);
        }
        output.reshape(A2.numRows, A2.numCols);
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            output.data[i] = A2.data[i] <= B.data[i];
        }
        return output;
    }

    public static DMatrixRMaj elements(DMatrixRMaj A2, BMatrixRMaj marked, DMatrixRMaj output) {
        if (A2.numRows != marked.numRows || A2.numCols != marked.numCols) {
            throw new MatrixDimensionException("Input matrices must have the same shape");
        }
        if (output == null) {
            output = new DMatrixRMaj(1, 1);
        }
        output.reshape(CommonOps_DDRM.countTrue(marked), 1);
        int N = A2.getNumElements();
        int index = 0;
        for (int i = 0; i < N; ++i) {
            if (!marked.data[i]) continue;
            output.data[index++] = A2.data[i];
        }
        return output;
    }

    public static int countTrue(BMatrixRMaj A2) {
        int total = 0;
        int N = A2.getNumElements();
        for (int i = 0; i < N; ++i) {
            if (!A2.data[i]) continue;
            ++total;
        }
        return total;
    }

    public static DMatrixRMaj concatColumns(DMatrixRMaj ... m3) {
        int rows = 0;
        int cols = 0;
        for (int i = 0; i < m3.length; ++i) {
            rows = Math.max(rows, m3[i].numRows);
            cols += m3[i].numCols;
        }
        DMatrixRMaj R5 = new DMatrixRMaj(rows, cols);
        int col = 0;
        for (int i = 0; i < m3.length; ++i) {
            CommonOps_DDRM.insert(m3[i], R5, 0, col);
            col += m3[i].numCols;
        }
        return R5;
    }

    public static DMatrixRMaj concatRows(DMatrixRMaj ... m3) {
        int rows = 0;
        int cols = 0;
        for (int i = 0; i < m3.length; ++i) {
            rows += m3[i].numRows;
            cols = Math.max(cols, m3[i].numCols);
        }
        DMatrixRMaj R5 = new DMatrixRMaj(rows, cols);
        int row = 0;
        for (int i = 0; i < m3.length; ++i) {
            CommonOps_DDRM.insert(m3[i], R5, row, 0);
            row += m3[i].numRows;
        }
        return R5;
    }

    public static DMatrixRMaj permuteRowInv(int[] pinv, DMatrixRMaj input, DMatrixRMaj output) {
        if (input.numRows > pinv.length) {
            throw new MatrixDimensionException("permutation vector must have at least as many elements as input has rows");
        }
        if (output == null) {
            output = new DMatrixRMaj(1, 1);
        }
        output.reshape(input.numRows, input.numCols);
        int m3 = input.numCols;
        for (int row = 0; row < input.numRows; ++row) {
            System.arraycopy(input.data, row * m3, output.data, pinv[row] * m3, m3);
        }
        return output;
    }
}

