/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.geotools.util.Utilities;

public class IndentedLineWriter
extends FilterWriter {
    private String margin = "";
    private boolean newLine = true;
    private boolean waitLF;

    public IndentedLineWriter(Writer out) {
        super(out);
    }

    public int getIdentation() {
        return this.margin.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndentation(int width) {
        Object object = this.lock;
        synchronized (object) {
            this.margin = Utilities.spaces(width);
        }
    }

    protected void beginNewLine() throws IOException {
        this.out.write(this.margin);
    }

    private void doWrite(int c2) throws IOException {
        assert (Thread.holdsLock(this.lock));
        if (this.newLine && (c2 != 10 || !this.waitLF)) {
            this.beginNewLine();
        }
        this.out.write(c2);
        this.newLine = c2 == 13 || c2 == 10;
        if (this.newLine) {
            this.waitLF = c2 == 13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doWrite(c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buffer, int offset, int length) throws IOException {
        int upper = offset + length;
        Object object = this.lock;
        synchronized (object) {
            block3: while (offset < upper) {
                if (this.newLine) {
                    this.doWrite(buffer[offset++]);
                    continue;
                }
                int lower = offset;
                do {
                    char c2;
                    if ((c2 = buffer[offset]) != '\r' && c2 != '\n') continue;
                    this.out.write(buffer, lower, offset - lower);
                    this.doWrite(c2);
                    ++offset;
                    continue block3;
                } while (++offset < upper);
                this.out.write(buffer, lower, offset - lower);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int offset, int length) throws IOException {
        int upper = offset + length;
        Object object = this.lock;
        synchronized (object) {
            block3: while (offset < upper) {
                if (this.newLine) {
                    this.doWrite(string.charAt(offset++));
                    continue;
                }
                int lower = offset;
                do {
                    char c2;
                    if ((c2 = string.charAt(offset)) != '\r' && c2 != '\n') continue;
                    this.out.write(string, lower, offset - lower);
                    this.doWrite(c2);
                    ++offset;
                    continue block3;
                } while (++offset < upper);
                this.out.write(string, lower, offset - lower);
                break;
            }
        }
    }
}

